/*
 * @Author: 纪泽龙 jizelong@qq.com
 * @Date: 2023-06-12 10:49:16
 * @LastEditors: 纪泽龙 jizelong@qq.com
 * @LastEditTime: 2023-06-13 16:19:48
 * @FilePath: /precision-effect-web/src/api/account/account.js
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import request from '@/utils/request'

// 查询账户列表
export function listAccount(query) {
  return request({
    url: '/system/account/list',
    method: 'get',
    params: query
  })
}


// 应收应付金额列表
export function getIncomeOrPayableList (query) {
  return request({
    url: '/trade/project/getIncomeOrPayableList',
    method: 'get',
    params: query
  })
}
// 查询账户详细
export function getAccount(accountId) {
  return request({
    url: '/system/account/' + accountId,
    method: 'get'
  })
}

// 新增账户
export function addAccount(data) {
  return request({
    url: '/system/account',
    method: 'post',
    data: data
  })
}

// 修改账户
export function updateAccount(data) {
  return request({
    url: '/system/account',
    method: 'put',
    data: data
  })
}

// 删除账户
export function delAccount(accountId) {
  return request({
    url: '/system/account/' + accountId,
    method: 'delete'
  })
}

// 导出账户
export function exportAccount(query) {
  return request({
    url: '/system/account/export',
    method: 'get',
    params: query
  })
}