package com.zehong.system.service.impl.tradeRoles.roles;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TTradeProject;
import com.zehong.system.service.impl.tradeRoles.TradeRolesAbstract;

/**
 *@author geng
 * 经办人
 */
public class Transactor extends TradeRolesAbstract {

    public Transactor(TTradeProject tTradeProject) {
        super(tTradeProject);
    }

    @Override
    public void setQueryParams() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if("myApply".equals(tTradeProject.getQueryType()) ||"all".equals(tTradeProject.getQueryType())){
            this.tTradeProject.setApplyDeptId(user.getDeptId());
            this.tTradeProject.setApplyId(user.getUserId());
        }
        if("myApproval".equals(tTradeProject.getQueryType()) || "all".equals(tTradeProject.getQueryType())){
            this.tTradeProject.setTradeDeptId(user.getDeptId());
            this.tTradeProject.setTradeTransactor(user.getUserId());
        }
    }

    @Override
    public void setOperators() {
        //申请中
        Long deptId = SecurityUtils.getLoginUser().getUser().getDeptId();
        if(deptId.equals(this.tTradeProject.getTradeDeptId()) && (TradeStatusEnum.evaluate.getTradeStatus().equals(this.tTradeProject.getTradeStatus())||TradeStatusEnum.reject.getTradeStatus().equals(this.tTradeProject.getTradeStatus()))){
            tTradeProject.getOperators().add("evaluate");
        }
    }
}
