package com.zehong.system.service.impl.tradeRoles.roles;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TTradeProject;
import com.zehong.system.service.impl.tradeRoles.TradeRolesAbstract;

/**
 * 其他角色
 */
public class OtherRoles extends TradeRolesAbstract {

    public OtherRoles(TTradeProject tTradeProject) {
        super(tTradeProject);
    }

    @Override
    public void setQueryParams() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if("myApply".equals(tTradeProject.getQueryType()) ||"all".equals(tTradeProject.getQueryType())){
            this.tTradeProject.setApplyDeptId(user.getDeptId());
            this.tTradeProject.setApplyId(user.getUserId());
        }
        if("myApproval".equals(tTradeProject.getQueryType()) || "all".equals(tTradeProject.getQueryType())){
            this.tTradeProject.setTradeDeptId(user.getDeptId());
            this.tTradeProject.setTradeTransactor(user.getUserId());
        }
    }

    @Override
    public void setOperators() {

    }
}
