package com.zehong.system.service.impl.tradeRoles.roles;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TTradeProject;
import com.zehong.system.service.impl.tradeRoles.TradeRolesAbstract;

/**
 * @author  geng
 * 部门长
 */
public class DeptLeader extends TradeRolesAbstract {

    public DeptLeader(TTradeProject tTradeProject) {
        super(tTradeProject);
    }

    @Override
    public void setQueryParams() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if("myApply".equals(tTradeProject.getQueryType()) ||"all".equals(tTradeProject.getQueryType())){
            this.tTradeProject.setApplyDeptId(user.getDeptId());
        }
        if("myApproval".equals(tTradeProject.getQueryType()) || "all".equals(tTradeProject.getQueryType())){
            this.tTradeProject.setTradeDeptId(user.getDeptId());
        }
    }

    @Override
    public void setOperators() {
        //判断买方还是卖方
        Long deptId = SecurityUtils.getLoginUser().getUser().getDeptId();
        //卖方部门
        if(deptId.equals(this.tTradeProject.getApplyDeptId()) && TradeStatusEnum.approval.getTradeStatus().equals(this.tTradeProject.getTradeStatus())){
            tTradeProject.getOperators().add("approval");
        }
        //买方部门
        if(deptId.equals(this.tTradeProject.getTradeDeptId()) && TradeStatusEnum.confirm.getTradeStatus().equals(this.tTradeProject.getTradeStatus())){
            tTradeProject.getOperators().add("confirm");
        }
    }
}
