package com.zehong.system.service.impl.purchase;


import com.alibaba.fastjson.JSONObject;
import com.zehong.common.core.domain.entity.SysRole;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.system.domain.TPurchase;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author geng
 * 采购操作权限策略
 */
public class PurchaseOperateStrategy {

    private final Map<String,JSONObject> operateMap = new HashMap<String,JSONObject>(){{
        put(PurchaseStatus.confirm.getStatus(),new JSONObject(){{
            put("deptLeader","confirm");
        }});
        put(PurchaseStatus.approval.getStatus(),new JSONObject(){{
            put("calculator","calculate");
        }});
    }};


    public void purchaseOperateStrategy(TPurchase purchase){
        List<SysRole> roles = SecurityUtils.getLoginUser().getUser().getRoles();
        roles.stream().forEach(item ->{
            if(operateMap.containsKey(purchase.getPurchaseStatus())){
                String operate = (String) operateMap.get(purchase.getPurchaseStatus()).get(item.getRoleKey());
                if(StringUtils.isNotEmpty(operate)){
                    purchase.getOperators().add(operate);
                }
            }
        });
    }

    /**
     * 采购审核
     */
    private enum PurchaseStatus{

        confirm("0"),approval("1"),complete("2"),reject("3");

        private String status;

        public String getStatus() {
            return status;
        }

        PurchaseStatus(String status) {
            this.status = status;
        }

    }

}
