package com.zehong.system.service.impl.debitCredit.roles;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TDebitCredit;
import com.zehong.system.service.impl.debitCredit.DebitCreditRolesAbstract;

/**
 * @author geng
 * 部门长
 */
public class DeptLeader extends DebitCreditRolesAbstract{

    public DeptLeader(TDebitCredit tDebitCredit) {
        super(tDebitCredit);
    }

    @Override
    public void setParams() {
        SysUser user = SecurityUtils.getLoginUser().getUser();
        if("myApply".equals(this.tDebitCredit.getQueryType()) ||"all".equals(this.tDebitCredit.getQueryType())){
            this.tDebitCredit.setDebitDeptId(user.getDeptId());
        }
        if("myApproval".equals(this.tDebitCredit.getQueryType()) || "all".equals(this.tDebitCredit.getQueryType())){
            this.tDebitCredit.setLendDeptId(user.getDeptId());
        }

    }

    @Override
    public void setOperators() {
        Long deptId = SecurityUtils.getLoginUser().getUser().getDeptId();
        //借贷部门
        if(DebitCreditEnum.stayRepay.getDebitCreditStatus().equals(this.tDebitCredit.getDebitStatus())
                && deptId.equals(this.tDebitCredit.getDebitDeptId())){
            this.tDebitCredit.getOperators().add("repay");
        }
        //借出部
        if(DebitCreditEnum.confirm.getDebitCreditStatus().equals(this.tDebitCredit.getDebitStatus())
                && deptId.equals(this.tDebitCredit.getLendDeptId())){
            this.tDebitCredit.getOperators().add("confirm");
        }
    }
}
