package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TCashOperateMapper;
import com.zehong.system.domain.TCashOperate;
import com.zehong.system.service.ITCashOperateService;

/**
 * 资金操作Service业务层处理
 * 
 * @author zehong
 * @date 2023-06-06
 */
@Service
public class TCashOperateServiceImpl implements ITCashOperateService 
{
    @Autowired
    private TCashOperateMapper tCashOperateMapper;

    /**
     * 查询资金操作
     * 
     * @param operateId 资金操作ID
     * @return 资金操作
     */
    @Override
    public TCashOperate selectTCashOperateById(Long operateId)
    {
        return tCashOperateMapper.selectTCashOperateById(operateId);
    }

    /**
     * 查询资金操作列表
     * 
     * @param tCashOperate 资金操作
     * @return 资金操作
     */
    @Override
    public List<TCashOperate> selectTCashOperateList(TCashOperate tCashOperate)
    {
        return tCashOperateMapper.selectTCashOperateList(tCashOperate);
    }

    /**
     * 新增资金操作
     * 
     * @param tCashOperate 资金操作
     * @return 结果
     */
    @Override
    public int insertTCashOperate(TCashOperate tCashOperate)
    {
        tCashOperate.setCreateTime(DateUtils.getNowDate());
        return tCashOperateMapper.insertTCashOperate(tCashOperate);
    }

    /**
     * 修改资金操作
     * 
     * @param tCashOperate 资金操作
     * @return 结果
     */
    @Override
    public int updateTCashOperate(TCashOperate tCashOperate)
    {
        tCashOperate.setUpdateTime(DateUtils.getNowDate());
        return tCashOperateMapper.updateTCashOperate(tCashOperate);
    }

    /**
     * 批量删除资金操作
     * 
     * @param operateIds 需要删除的资金操作ID
     * @return 结果
     */
    @Override
    public int deleteTCashOperateByIds(Long[] operateIds)
    {
        return tCashOperateMapper.deleteTCashOperateByIds(operateIds);
    }

    /**
     * 删除资金操作信息
     * 
     * @param operateId 资金操作ID
     * @return 结果
     */
    @Override
    public int deleteTCashOperateById(Long operateId)
    {
        return tCashOperateMapper.deleteTCashOperateById(operateId);
    }
}
