package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TBorrowingApplyForMapper;
import com.zehong.system.domain.TBorrowingApplyFor;
import com.zehong.system.service.ITBorrowingApplyForService;

/**
 * 借支申请Service业务层处理
 *
 * @author zehong
 * @date 2023-06-15
 */
@Service
public class TBorrowingApplyForServiceImpl implements ITBorrowingApplyForService
{
    @Autowired
    private TBorrowingApplyForMapper tBorrowingApplyForMapper;

    /**
     * 查询借支申请
     *
     * @param borrowing 借支申请ID
     * @return 借支申请
     */
    @Override
    public TBorrowingApplyFor selectTBorrowingApplyForById(Long borrowing)
    {
        return tBorrowingApplyForMapper.selectTBorrowingApplyForById(borrowing);
    }

    /**
     * 查询借支申请列表
     *
     * @param tBorrowingApplyFor 借支申请
     * @return 借支申请
     */
    @Override
    public List<TBorrowingApplyFor> selectTBorrowingApplyForList(TBorrowingApplyFor tBorrowingApplyFor)
    {
        return tBorrowingApplyForMapper.selectTBorrowingApplyForList(tBorrowingApplyFor);
    }

    /**
     * 新增借支申请
     *
     * @param tBorrowingApplyFor 借支申请
     * @return 结果
     */
    @Override
    public int insertTBorrowingApplyFor(TBorrowingApplyFor tBorrowingApplyFor)
    {
        tBorrowingApplyFor.setCreateTime(DateUtils.getNowDate());
        return tBorrowingApplyForMapper.insertTBorrowingApplyFor(tBorrowingApplyFor);
    }

    /**
     * 修改借支申请
     *
     * @param tBorrowingApplyFor 借支申请
     * @return 结果
     */
    @Override
    public int updateTBorrowingApplyFor(TBorrowingApplyFor tBorrowingApplyFor)
    {
        tBorrowingApplyFor.setUpdateTime(DateUtils.getNowDate());
        return tBorrowingApplyForMapper.updateTBorrowingApplyFor(tBorrowingApplyFor);
    }

    /**
     * 批量删除借支申请
     *
     * @param borrowings 需要删除的借支申请ID
     * @return 结果
     */
    @Override
    public int deleteTBorrowingApplyForByIds(Long[] borrowings)
    {
        return tBorrowingApplyForMapper.deleteTBorrowingApplyForByIds(borrowings);
    }

    /**
     * 删除借支申请信息
     *
     * @param borrowing 借支申请ID
     * @return 结果
     */
    @Override
    public int deleteTBorrowingApplyForById(Long borrowing)
    {
        return tBorrowingApplyForMapper.deleteTBorrowingApplyForById(borrowing);
    }

    /**
     * 查询部门余额是否足够
     * @param tBorrowingApplyFor
     * @return
     */
    @Override
    public int selectTacc(TBorrowingApplyFor tBorrowingApplyFor) {
        return tBorrowingApplyForMapper.selectTacc(tBorrowingApplyFor);
    }

    /**
     * 修改部门余额
     * @param tBorrowingApplyFor
     */
    @Override
    public void deletebBalance(TBorrowingApplyFor tBorrowingApplyFor) {
        tBorrowingApplyForMapper.deletebBalance(tBorrowingApplyFor);
    }
}
