package com.zehong.system.service.impl;

import java.math.BigDecimal;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TAccountMapper;
import com.zehong.system.domain.TAccount;
import com.zehong.system.service.ITAccountService;

/**
 * 账户Service业务层处理
 * 
 * @author zehong
 * @date 2023-06-06
 */
@Service
public class TAccountServiceImpl implements ITAccountService 
{
    @Autowired
    private TAccountMapper tAccountMapper;

    /**
     * 查询账户
     * 
     * @param accountId 账户ID
     * @return 账户
     */
    @Override
    public TAccount selectTAccountById(Long accountId)
    {
        return tAccountMapper.selectTAccountById(accountId);
    }

    /**
     * 查询账户列表
     * 
     * @param tAccount 账户
     * @return 账户
     */
    @Override
    public List<TAccount> selectTAccountList(TAccount tAccount)
    {
        return tAccountMapper.selectTAccountList(tAccount);
    }

    /**
     * 新增账户
     * 
     * @param tAccount 账户
     * @return 结果
     */
    @Override
    public int insertTAccount(TAccount tAccount)
    {
        tAccount.setCreateTime(DateUtils.getNowDate());
        return tAccountMapper.insertTAccount(tAccount);
    }

    /**
     * 修改账户
     * 
     * @param tAccount 账户
     * @return 结果
     */
    @Override
    public int updateTAccount(TAccount tAccount)
    {
        tAccount.setUpdateTime(DateUtils.getNowDate());
        return tAccountMapper.updateTAccount(tAccount);
    }

    /**
     * 批量删除账户
     * 
     * @param accountIds 需要删除的账户ID
     * @return 结果
     */
    @Override
    public int deleteTAccountByIds(Long[] accountIds)
    {
        return tAccountMapper.deleteTAccountByIds(accountIds);
    }

    /**
     * 删除账户信息
     * 
     * @param accountId 账户ID
     * @return 结果
     */
    @Override
    public int deleteTAccountById(Long accountId)
    {
        return tAccountMapper.deleteTAccountById(accountId);
    }

    @Override
    public boolean checkAccountCanTrade(Long deptId, BigDecimal amount) {
        TAccount tAccount=new TAccount();
        tAccount.setDeptId(deptId);
        List<TAccount> rst=tAccountMapper.selectTAccountList(tAccount);
        if(rst!=null&&rst.size()>0){
            if(rst.get(0).getAbleAmount().compareTo(amount)>=0) {
                return true;
            }else {
                return false;
            }
        }else{
            return false;
        }
    }
}
