package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTransactionProject;

/**
 * 交易项目Service接口
 * 
 * @author zehong
 * @date 2023-06-05
 */
public interface ITTransactionProjectService 
{
    /**
     * 查询交易项目
     * 
     * @param transactionProjectId 交易项目ID
     * @return 交易项目
     */
    public TTransactionProject selectTTransactionProjectById(Long transactionProjectId);

    /**
     * 查询交易项目列表
     * 
     * @param tTransactionProject 交易项目
     * @return 交易项目集合
     */
    public List<TTransactionProject> selectTTransactionProjectList(TTransactionProject tTransactionProject);

    /**
     * 新增交易项目
     * 
     * @param tTransactionProject 交易项目
     * @return 结果
     */
    public int insertTTransactionProject(TTransactionProject tTransactionProject);

    /**
     * 修改交易项目
     * 
     * @param tTransactionProject 交易项目
     * @return 结果
     */
    public int updateTTransactionProject(TTransactionProject tTransactionProject);

    /**
     * 批量删除交易项目
     * 
     * @param transactionProjectIds 需要删除的交易项目ID
     * @return 结果
     */
    public int deleteTTransactionProjectByIds(Long[] transactionProjectIds);

    /**
     * 删除交易项目信息
     * 
     * @param transactionProjectId 交易项目ID
     * @return 结果
     */
    public int deleteTTransactionProjectById(Long transactionProjectId);

    /**
     * 导入数据
     *
     * @param transactionList 数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     */
    public String importTransaction(List<TTransactionProject> transactionList, Boolean isUpdateSupport);

}
