package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TTradeProject;

/**
 * 交易项目Service接口
 * 
 * @author zehong
 * @date 2023-06-08
 */
public interface ITTradeProjectService 
{
    /**
     * 查询交易项目
     * 
     * @param tradeId 交易项目ID
     * @return 交易项目
     */
    public TTradeProject selectTTradeProjectById(Long tradeId);

    /**
     * 查询交易项目列表
     * 
     * @param tTradeProject 交易项目
     * @return 交易项目集合
     */
    public List<TTradeProject> selectTTradeProjectList(TTradeProject tTradeProject);

    /**
     * 根据角色查询数据
     * @param tTradeProject 交易实体
     * @return
     */
    List<TTradeProject> selectTTradeProjectListByRoles(TTradeProject tTradeProject);

    /**
     * 新增交易项目
     * 
     * @param tTradeProject 交易项目
     * @return 结果
     */
    public int insertTTradeProject(TTradeProject tTradeProject);

    /**
     * 修改交易项目
     * 
     * @param tTradeProject 交易项目
     * @return 结果
     */
    public int updateTTradeProject(TTradeProject tTradeProject);

    /**
     * 批量删除交易项目
     * 
     * @param tradeIds 需要删除的交易项目ID
     * @return 结果
     */
    public int deleteTTradeProjectByIds(Long[] tradeIds);

    /**
     * 删除交易项目信息
     * 
     * @param tradeId 交易项目ID
     * @return 结果
     */
    public int deleteTTradeProjectById(Long tradeId);

    /**
     * 交易结算
     * @param tTradeProject
     * @return
     */
    int settlementTrade(TTradeProject tTradeProject);
    public List<TTradeProject> getIncomeOrPayableList(TTradeProject tTradeProject);
}
