package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TCashOperate;

/**
 * 资金操作Service接口
 * 
 * @author zehong
 * @date 2023-06-06
 */
public interface ITCashOperateService 
{
    /**
     * 查询资金操作
     * 
     * @param operateId 资金操作ID
     * @return 资金操作
     */
    public TCashOperate selectTCashOperateById(Long operateId);

    /**
     * 查询资金操作列表
     * 
     * @param tCashOperate 资金操作
     * @return 资金操作集合
     */
    public List<TCashOperate> selectTCashOperateList(TCashOperate tCashOperate);

    /**
     * 新增资金操作
     * 
     * @param tCashOperate 资金操作
     * @return 结果
     */
    public int insertTCashOperate(TCashOperate tCashOperate);

    /**
     * 修改资金操作
     * 
     * @param tCashOperate 资金操作
     * @return 结果
     */
    public int updateTCashOperate(TCashOperate tCashOperate);

    /**
     * 批量删除资金操作
     * 
     * @param operateIds 需要删除的资金操作ID
     * @return 结果
     */
    public int deleteTCashOperateByIds(Long[] operateIds);

    /**
     * 删除资金操作信息
     * 
     * @param operateId 资金操作ID
     * @return 结果
     */
    public int deleteTCashOperateById(Long operateId);
}
