package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TBorrowingApplyFor;

/**
 * 借支申请Service接口
 *
 * @author zehong
 * @date 2023-06-15
 */
public interface ITBorrowingApplyForService
{
    /**
     * 查询借支申请
     *
     * @param borrowing 借支申请ID
     * @return 借支申请
     */
    public TBorrowingApplyFor selectTBorrowingApplyForById(Long borrowing);

    /**
     * 查询借支申请列表
     *
     * @param tBorrowingApplyFor 借支申请
     * @return 借支申请集合
     */
    public List<TBorrowingApplyFor> selectTBorrowingApplyForList(TBorrowingApplyFor tBorrowingApplyFor);

    /**
     * 新增借支申请
     *
     * @param tBorrowingApplyFor 借支申请
     * @return 结果
     */
    public int insertTBorrowingApplyFor(TBorrowingApplyFor tBorrowingApplyFor);

    /**
     * 修改借支申请
     *
     * @param tBorrowingApplyFor 借支申请
     * @return 结果
     */
    public int updateTBorrowingApplyFor(TBorrowingApplyFor tBorrowingApplyFor);

    /**
     * 批量删除借支申请
     *
     * @param borrowings 需要删除的借支申请ID
     * @return 结果
     */
    public int deleteTBorrowingApplyForByIds(Long[] borrowings);

    /**
     * 删除借支申请信息
     *
     * @param borrowing 借支申请ID
     * @return 结果
     */
    public int deleteTBorrowingApplyForById(Long borrowing);

    /**
     * 查询部门余额是否足够
     * @param tBorrowingApplyFor
     * @return
     */
    int selectTacc(TBorrowingApplyFor tBorrowingApplyFor);

    /**
     * 修改部门余额
     * @param tBorrowingApplyFor
     */
    void deletebBalance(TBorrowingApplyFor tBorrowingApplyFor);
}
