package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTransactionProject;

/**
 * 交易项目Mapper接口
 * 
 * @author zehong
 * @date 2023-06-05
 */
public interface TTransactionProjectMapper 
{
    /**
     * 查询交易项目
     * 
     * @param transactionProjectId 交易项目ID
     * @return 交易项目
     */
    public TTransactionProject selectTTransactionProjectById(Long transactionProjectId);

    /**
     * 查询交易项目
     *
     * @param transactionProjectName 交易项目名称
     * @return 交易项目
     */
    public TTransactionProject selectTransactionProjectByName(String transactionProjectName);

    /**
     * 查询交易项目列表
     * 
     * @param tTransactionProject 交易项目
     * @return 交易项目集合
     */
    public List<TTransactionProject> selectTTransactionProjectList(TTransactionProject tTransactionProject);

    /**
     * 新增交易项目
     * 
     * @param tTransactionProject 交易项目
     * @return 结果
     */
    public int insertTTransactionProject(TTransactionProject tTransactionProject);

    /**
     * 修改交易项目
     * 
     * @param tTransactionProject 交易项目
     * @return 结果
     */
    public int updateTTransactionProject(TTransactionProject tTransactionProject);

    /**
     * 删除交易项目
     * 
     * @param transactionProjectId 交易项目ID
     * @return 结果
     */
    public int deleteTTransactionProjectById(Long transactionProjectId);

    /**
     * 批量删除交易项目
     * 
     * @param transactionProjectIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTransactionProjectByIds(Long[] transactionProjectIds);
}
