package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTradeProject;

/**
 * 交易项目Mapper接口
 * 
 * @author zehong
 * @date 2023-06-08
 */
public interface TTradeProjectMapper 
{
    /**
     * 查询交易项目
     * 
     * @param tradeId 交易项目ID
     * @return 交易项目
     */
    public TTradeProject selectTTradeProjectById(Long tradeId);

    /**
     * 查询交易项目列表
     * 
     * @param tTradeProject 交易项目
     * @return 交易项目集合
     */
    public List<TTradeProject> selectTTradeProjectList(TTradeProject tTradeProject);

    /**
     * 新增交易项目
     * 
     * @param tTradeProject 交易项目
     * @return 结果
     */
    public int insertTTradeProject(TTradeProject tTradeProject);

    /**
     * 修改交易项目
     * 
     * @param tTradeProject 交易项目
     * @return 结果
     */
    public int updateTTradeProject(TTradeProject tTradeProject);

    /**
     * 删除交易项目
     * 
     * @param tradeId 交易项目ID
     * @return 结果
     */
    public int deleteTTradeProjectById(Long tradeId);

    /**
     * 批量删除交易项目
     * 
     * @param tradeIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTradeProjectByIds(Long[] tradeIds);

    /**
     * 获取进货交易尾款
     * @param tradeDeptId 进货部门id
     * @return
     */
    List<TTradeProject> getTradePendingPaymentInfo(Long tradeDeptId);

    /**
     * 查询应收、应付项目列表
     * @param tTradeProject
     * @return
     */
    public List<TTradeProject> getIncomeOrPayableList(TTradeProject tTradeProject);
}
