package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPurchase;

/**
 * 外部采购（报销）申请Mapper接口
 * 
 * @author zehong
 * @date 2023-06-16
 */
public interface TPurchaseMapper 
{
    /**
     * 查询外部采购（报销）申请
     * 
     * @param purchaseId 外部采购（报销）申请ID
     * @return 外部采购（报销）申请
     */
    public TPurchase selectTPurchaseById(Long purchaseId);

    /**
     * 查询外部采购（报销）申请列表
     * 
     * @param tPurchase 外部采购（报销）申请
     * @return 外部采购（报销）申请集合
     */
    public List<TPurchase> selectTPurchaseList(TPurchase tPurchase);

    /**
     * 新增外部采购（报销）申请
     * 
     * @param tPurchase 外部采购（报销）申请
     * @return 结果
     */
    public int insertTPurchase(TPurchase tPurchase);

    /**
     * 修改外部采购（报销）申请
     * 
     * @param tPurchase 外部采购（报销）申请
     * @return 结果
     */
    public int updateTPurchase(TPurchase tPurchase);

    /**
     * 删除外部采购（报销）申请
     * 
     * @param purchaseId 外部采购（报销）申请ID
     * @return 结果
     */
    public int deleteTPurchaseById(Long purchaseId);

    /**
     * 批量删除外部采购（报销）申请
     * 
     * @param purchaseIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPurchaseByIds(Long[] purchaseIds);
}
