package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TDebitCredit;

/**
 * 借贷Mapper接口
 * 
 * @author zehong
 * @date 2023-06-20
 */
public interface TDebitCreditMapper 
{
    /**
     * 查询借贷
     * 
     * @param debitId 借贷ID
     * @return 借贷
     */
    public TDebitCredit selectTDebitCreditById(Long debitId);

    /**
     * 查询借贷列表
     * 
     * @param tDebitCredit 借贷
     * @return 借贷集合
     */
    public List<TDebitCredit> selectTDebitCreditList(TDebitCredit tDebitCredit);

    /**
     * 新增借贷
     * 
     * @param tDebitCredit 借贷
     * @return 结果
     */
    public int insertTDebitCredit(TDebitCredit tDebitCredit);

    /**
     * 修改借贷
     * 
     * @param tDebitCredit 借贷
     * @return 结果
     */
    public int updateTDebitCredit(TDebitCredit tDebitCredit);

    /**
     * 删除借贷
     * 
     * @param debitId 借贷ID
     * @return 结果
     */
    public int deleteTDebitCreditById(Long debitId);

    /**
     * 批量删除借贷
     * 
     * @param debitIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTDebitCreditByIds(Long[] debitIds);
}
