package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TAccount;

/**
 * 账户Mapper接口
 * 
 * @author zehong
 * @date 2023-06-05
 */
public interface TAccountMapper 
{
    /**
     * 查询账户
     * 
     * @param accountId 账户ID
     * @return 账户
     */
    public TAccount selectTAccountById(Long accountId);

    /**
     * 查询账户列表
     * 
     * @param tAccount 账户
     * @return 账户集合
     */
    public List<TAccount> selectTAccountList(TAccount tAccount);

    /**
     * 新增账户
     * 
     * @param tAccount 账户
     * @return 结果
     */
    public int insertTAccount(TAccount tAccount);

    /**
     * 修改账户
     * 
     * @param tAccount 账户
     * @return 结果
     */
    public int updateTAccount(TAccount tAccount);

    /**
     * 删除账户
     * 
     * @param accountId 账户ID
     * @return 结果
     */
    public int deleteTAccountById(Long accountId);

    /**
     * 批量删除账户
     * 
     * @param accountIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTAccountByIds(Long[] accountIds);

}
