package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 交易项目对象 t_transaction_project
 * 
 * @author zehong
 * @date 2023-06-06
 */
public class TTransactionProject extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 交易项目主键id */
    private Long transactionProjectId;

    /** 交易项目名称 */
    @Excel(name = "交易项目名称")
    private String transactionProjectName;

    /** 交易细项名称 */
    @Excel(name = "交易细项名称")
    private String transactionItemName;

    /** 内容 */
    @Excel(name = "内容")
    private String context;

    /** 定价类型：1.单价 2.议价 */
    @Excel(name = "定价类型：1定价 2议价")
    private String priceType;

    /** 单价 */
    @Excel(name = "单价")
    private BigDecimal price;

    /** 部门 */
    @Excel(name = "部门：103泽宏云研发部，104泽宏云技术部，105泽宏云销售部，200核算部，201综合管理部，202销售服务部")
    private Long deptId;

    /**部门名称*/
    private String deptName;

    /** 是否删除：0否，1是 */
    private String isDel;

    public void setTransactionProjectId(Long transactionProjectId) 
    {
        this.transactionProjectId = transactionProjectId;
    }

    public Long getTransactionProjectId() 
    {
        return transactionProjectId;
    }
    public void setTransactionProjectName(String transactionProjectName) 
    {
        this.transactionProjectName = transactionProjectName;
    }

    public String getTransactionProjectName() 
    {
        return transactionProjectName;
    }
    public void setTransactionItemName(String transactionItemName) 
    {
        this.transactionItemName = transactionItemName;
    }

    public String getTransactionItemName() 
    {
        return transactionItemName;
    }
    public void setContext(String context) 
    {
        this.context = context;
    }

    public String getContext() 
    {
        return context;
    }
    public void setPriceType(String priceType) 
    {
        this.priceType = priceType;
    }

    public String getPriceType() 
    {
        return priceType;
    }
    public void setPrice(BigDecimal price) 
    {
        this.price = price;
    }

    public BigDecimal getPrice()
    {
        return price;
    }
    public void setDeptId(Long deptId)
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("transactionProjectId", getTransactionProjectId())
            .append("transactionProjectName", getTransactionProjectName())
            .append("transactionItemName", getTransactionItemName())
            .append("context", getContext())
            .append("priceType", getPriceType())
            .append("price", getPrice())
            .append("deptId", getDeptId())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
