package com.zehong.system.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 交易项目对象 t_trade_project
 * 
 * @author zehong
 * @date 2023-06-08
 */
public class TTradeProject extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 交易主键 */
    private Long tradeId;

    /** 单据编号 */
    @Excel(name = "单据编号")
    private String receiptNum;

    /** 关联交易项目 */
    @Excel(name = "关联交易项目")
    private Long relationTransactionProjectId;

    /** 申请人 */
    @Excel(name = "申请人")
    private Long applyId;

    /** 申请部门 */
    @Excel(name = "申请部门")
    private Long applyDeptId;

    /** 申请部门长 */
    @Excel(name = "申请部门长")
    private Long applyDeptManagerId;

    /** 交易经办人 */
    @Excel(name = "交易经办人")
    private Long tradeTransactor;

    /** 交易部门 */
    @Excel(name = "交易部门")
    private Long tradeDeptId;

    /** 交易单价 */
    @Excel(name = "交易单价")
    private BigDecimal tradePrice;

    /** 交易数量 */
    @Excel(name = "交易数量")
    private BigDecimal tradeCount;

    /** 交易总价 */
    @Excel(name = "交易总价")
    private BigDecimal tradeTotal;

    /** 交易评分 */
    @Excel(name = "交易评分")
    private Integer tradeScore;

    /** 交易部门长 */
    @Excel(name = "交易部门长")
    private Long tradeDeptManagerId;

    /** 结算时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结算时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date settlementTime;

    /** 交易成交价 */
    @Excel(name = "交易成交价")
    private BigDecimal dealPrice;

    /** 尾款 */
    @Excel(name = "尾款")
    private BigDecimal pendingPayment;

    /** 附件 */
    @Excel(name = "附件")
    private String attachmentUrl;

    /** 交易状态：0.申请中 1.待经办人评价 2.待对方部门长确认 3.待本部门长确认 4.驳回 5.完成 */
    @Excel(name = "交易状态：0.申请中 1.待经办人评价 2.待对方部门长确认 3.待本部门长确认 4.驳回 5.完成")
    private String tradeStatus;

    /** 是否删除：0否，1是 */
    @Excel(name = "是否删除：0否，1是")
    private String isDel;

    private String applyName;

    private String applyDeptName;

    private String tradeDeptName;

    /**查询类型：all全部 myApply我申请的 myApproval我的审批*/
    private String queryType;

    private String tradeDeptManagerName;

    private String dealRemark;

    private String applyDeptManagerName;

    private Long queryApplyDeptId;

    private Long queryTradeDeptId;

    public String getDealRemark() {
        return dealRemark;
    }

    public void setDealRemark(String dealRemark) {
        this.dealRemark = dealRemark;
    }


    public String getTradeTransactorName() {
        return tradeTransactorName;
    }

    public void setTradeTransactorName(String tradeTransactorName) {
        this.tradeTransactorName = tradeTransactorName;
    }

    private String tradeTransactorName;

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    private String projectName;

    /**操作类型*/
    private List<String> operators = new ArrayList<>();

    public void setTradeId(Long tradeId) 
    {
        this.tradeId = tradeId;
    }

    public Long getTradeId() 
    {
        return tradeId;
    }
    public void setReceiptNum(String receiptNum) 
    {
        this.receiptNum = receiptNum;
    }

    public String getReceiptNum() 
    {
        return receiptNum;
    }
    public void setRelationTransactionProjectId(Long relationTransactionProjectId) 
    {
        this.relationTransactionProjectId = relationTransactionProjectId;
    }

    public Long getRelationTransactionProjectId() 
    {
        return relationTransactionProjectId;
    }
    public void setApplyId(Long applyId) 
    {
        this.applyId = applyId;
    }

    public Long getApplyId() 
    {
        return applyId;
    }
    public void setApplyDeptId(Long applyDeptId) 
    {
        this.applyDeptId = applyDeptId;
    }

    public Long getApplyDeptId() 
    {
        return applyDeptId;
    }
    public void setApplyDeptManagerId(Long applyDeptManagerId) 
    {
        this.applyDeptManagerId = applyDeptManagerId;
    }

    public Long getApplyDeptManagerId() 
    {
        return applyDeptManagerId;
    }
    public void setTradeTransactor(Long tradeTransactor)
    {
        this.tradeTransactor = tradeTransactor;
    }

    public Long getTradeTransactor() 
    {
        return tradeTransactor;
    }
    public void setTradeDeptId(Long tradeDeptId) 
    {
        this.tradeDeptId = tradeDeptId;
    }

    public Long getTradeDeptId() 
    {
        return tradeDeptId;
    }
    public void setTradePrice(BigDecimal tradePrice)
    {
        this.tradePrice = tradePrice;
    }

    public BigDecimal getTradePrice()
    {
        return tradePrice;
    }
    public void setTradeCount(BigDecimal tradeCount)
    {
        this.tradeCount = tradeCount;
    }

    public BigDecimal getTradeCount()
    {
        return tradeCount;
    }
    public void setTradeTotal(BigDecimal tradeTotal) 
    {
        this.tradeTotal = tradeTotal;
    }

    public BigDecimal getTradeTotal() 
    {
        return tradeTotal;
    }
    public void setTradeScore(Integer tradeScore) 
    {
        this.tradeScore = tradeScore;
    }

    public Integer getTradeScore() 
    {
        return tradeScore;
    }
    public void setTradeDeptManagerId(Long tradeDeptManagerId) 
    {
        this.tradeDeptManagerId = tradeDeptManagerId;
    }

    public Long getTradeDeptManagerId() 
    {
        return tradeDeptManagerId;
    }
    public void setSettlementTime(Date settlementTime) 
    {
        this.settlementTime = settlementTime;
    }

    public Date getSettlementTime() 
    {
        return settlementTime;
    }
    public void setDealPrice(BigDecimal dealPrice) 
    {
        this.dealPrice = dealPrice;
    }

    public BigDecimal getDealPrice() 
    {
        return dealPrice;
    }
    public void setPendingPayment(BigDecimal pendingPayment) 
    {
        this.pendingPayment = pendingPayment;
    }

    public BigDecimal getPendingPayment() 
    {
        return pendingPayment;
    }
    public void setAttachmentUrl(String attachmentUrl) 
    {
        this.attachmentUrl = attachmentUrl;
    }

    public String getAttachmentUrl() 
    {
        return attachmentUrl;
    }
    public void setTradeStatus(String tradeStatus) 
    {
        this.tradeStatus = tradeStatus;
    }

    public String getTradeStatus() 
    {
        return tradeStatus;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getApplyName() {
        return applyName;
    }

    public void setApplyName(String applyName) {
        this.applyName = applyName;
    }

    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }

    public String getTradeDeptName() {
        return tradeDeptName;
    }

    public void setTradeDeptName(String tradeDeptName) {
        this.tradeDeptName = tradeDeptName;
    }

    public String getQueryType() {
        return queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public List<String> getOperators() {
        return operators;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public String getTradeDeptManagerName() {
        return tradeDeptManagerName;
    }

    public void setTradeDeptManagerName(String tradeDeptManagerName) {
        this.tradeDeptManagerName = tradeDeptManagerName;
    }

    public String getApplyDeptManagerName() {
        return applyDeptManagerName;
    }

    public void setApplyDeptManagerName(String applyDeptManagerName) {
        this.applyDeptManagerName = applyDeptManagerName;
    }

    public Long getQueryApplyDeptId() {
        return queryApplyDeptId;
    }

    public void setQueryApplyDeptId(Long queryApplyDeptId) {
        this.queryApplyDeptId = queryApplyDeptId;
    }

    public Long getQueryTradeDeptId() {
        return queryTradeDeptId;
    }

    public void setQueryTradeDeptId(Long queryTradeDeptId) {
        this.queryTradeDeptId = queryTradeDeptId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("tradeId", getTradeId())
            .append("receiptNum", getReceiptNum())
            .append("relationTransactionProjectId", getRelationTransactionProjectId())
            .append("applyId", getApplyId())
            .append("applyDeptId", getApplyDeptId())
            .append("applyDeptManagerId", getApplyDeptManagerId())
            .append("tradeTransactor", getTradeTransactor())
            .append("tradeDeptId", getTradeDeptId())
            .append("tradePrice", getTradePrice())
            .append("tradeCount", getTradeCount())
            .append("tradeTotal", getTradeTotal())
            .append("tradeScore", getTradeScore())
            .append("tradeDeptManagerId", getTradeDeptManagerId())
            .append("settlementTime", getSettlementTime())
            .append("dealPrice", getDealPrice())
            .append("pendingPayment", getPendingPayment())
            .append("attachmentUrl", getAttachmentUrl())
            .append("tradeStatus", getTradeStatus())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .append("dealRemark", getDealRemark())
            .toString();
    }
}
