package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 外部采购（报销）申请对象 t_purchase
 * 
 * @author zehong
 * @date 2023-06-16
 */
public class TPurchase extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 采购主键 */
    private Long purchaseId;

    /** 采购申请部门 */
    @Excel(name = "采购申请部门")
    private Long purchaseDeptId;

    public Long getHandledByUserId() {
        return handledByUserId;
    }

    public void setHandledByUserId(Long handledByUserId) {
        this.handledByUserId = handledByUserId;
    }
    private String userName;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPurchaseDeptName() {
        return purchaseDeptName;
    }

    public void setPurchaseDeptName(String purchaseDeptName) {
        this.purchaseDeptName = purchaseDeptName;
    }

    private String purchaseDeptName;

    private Long handledByUserId;
    /** 采购名称 */
    @Excel(name = "采购名称")
    private String purchaseName;

    /** 规格 */
    @Excel(name = "规格")
    private String specifications;

    /** 型号 */
    @Excel(name = "型号")
    private String modelType;

    /** 用途说明 */
    @Excel(name = "用途说明")
    private String applicationDescription;

    /** 使用人 */
    @Excel(name = "使用人")
    private Long userId;

    /** 单价 */
    @Excel(name = "单价")
    private BigDecimal price;

    /** 数量 */
    @Excel(name = "数量")
    private Long count;

    /** 总价 */
    @Excel(name = "总价")
    private BigDecimal total;

    /** 采购申请部门长 */
    @Excel(name = "采购申请部门长")
    private Long purchaseDeptManagerId;

    /** 审批人 */
    @Excel(name = "审批人")
    private Long approvedUserId;

    /** 是否删除：0否，1是 */
    @Excel(name = "是否删除：0否，1是")
    private String isDel;

    /** 采购状态：0.待部门长审核 1.核算部审批 2.完成 3.驳回 */
    @Excel(name = "采购状态：0.待部门长审核 1.核算部审批 2.完成 3.驳回")
    private String purchaseStatus;

    /** 审核时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "审核时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date approvedTime;

    /**
     * 操作权限
     */
    private List<String> operators = new ArrayList<>();

    private String approvedUserName;

    private String purchaseDeptManagerName;

    public void setPurchaseId(Long purchaseId) 
    {
        this.purchaseId = purchaseId;
    }

    public Long getPurchaseId() 
    {
        return purchaseId;
    }
    public void setPurchaseDeptId(Long purchaseDeptId) 
    {
        this.purchaseDeptId = purchaseDeptId;
    }

    public Long getPurchaseDeptId() 
    {
        return purchaseDeptId;
    }
    public void setPurchaseName(String purchaseName) 
    {
        this.purchaseName = purchaseName;
    }

    public String getPurchaseName() 
    {
        return purchaseName;
    }
    public void setSpecifications(String specifications) 
    {
        this.specifications = specifications;
    }

    public String getSpecifications() 
    {
        return specifications;
    }
    public void setModelType(String modelType) 
    {
        this.modelType = modelType;
    }

    public String getModelType() 
    {
        return modelType;
    }
    public void setApplicationDescription(String applicationDescription) 
    {
        this.applicationDescription = applicationDescription;
    }

    public String getApplicationDescription() 
    {
        return applicationDescription;
    }
    public void setUserId(Long userId) 
    {
        this.userId = userId;
    }

    public Long getUserId() 
    {
        return userId;
    }
    public void setPrice(BigDecimal price) 
    {
        this.price = price;
    }

    public BigDecimal getPrice() 
    {
        return price;
    }
    public void setCount(Long count) 
    {
        this.count = count;
    }

    public Long getCount() 
    {
        return count;
    }
    public void setTotal(BigDecimal total) 
    {
        this.total = total;
    }

    public BigDecimal getTotal() 
    {
        return total;
    }
    public void setPurchaseDeptManagerId(Long purchaseDeptManagerId) 
    {
        this.purchaseDeptManagerId = purchaseDeptManagerId;
    }

    public Long getPurchaseDeptManagerId() 
    {
        return purchaseDeptManagerId;
    }
    public void setApprovedUserId(Long approvedUserId) 
    {
        this.approvedUserId = approvedUserId;
    }

    public Long getApprovedUserId() 
    {
        return approvedUserId;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setPurchaseStatus(String purchaseStatus) 
    {
        this.purchaseStatus = purchaseStatus;
    }

    public String getPurchaseStatus() 
    {
        return purchaseStatus;
    }
    public void setApprovedTime(Date approvedTime) 
    {
        this.approvedTime = approvedTime;
    }

    public Date getApprovedTime() 
    {
        return approvedTime;
    }

    public List<String> getOperators() {
        return operators;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public String getApprovedUserName() {
        return approvedUserName;
    }

    public void setApprovedUserName(String approvedUserName) {
        this.approvedUserName = approvedUserName;
    }

    public String getPurchaseDeptManagerName() {
        return purchaseDeptManagerName;
    }

    public void setPurchaseDeptManagerName(String purchaseDeptManagerName) {
        this.purchaseDeptManagerName = purchaseDeptManagerName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("purchaseId", getPurchaseId())
            .append("purchaseDeptId", getPurchaseDeptId())
            .append("purchaseName", getPurchaseName())
            .append("specifications", getSpecifications())
            .append("modelType", getModelType())
            .append("applicationDescription", getApplicationDescription())
            .append("userId", getUserId())
            .append("price", getPrice())
            .append("count", getCount())
            .append("total", getTotal())
            .append("purchaseDeptManagerId", getPurchaseDeptManagerId())
            .append("approvedUserId", getApprovedUserId())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .append("isDel", getIsDel())
            .append("updateTime", getUpdateTime())
            .append("purchaseStatus", getPurchaseStatus())
            .append("approvedTime", getApprovedTime())
            .toString();
    }
}
