package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 借贷对象 t_debit_credit
 * 
 * @author zehong
 * @date 2023-06-20
 */
public class TDebitCredit extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 借贷主键 */
    private Long debitId;

    /** 借贷部门 */
    @Excel(name = "借贷部门")
    private Long debitDeptId;

    /** 经办人/申领人 */
    @Excel(name = "经办人/申领人")
    private Long operatorId;

    /** 出借部门 */
    @Excel(name = "出借部门")
    private Long lendDeptId;

    /** 出借部门长 */
    @Excel(name = "出借部门长")
    private Long lendDeptManageId;

    /** 登记日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "登记日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date registerTime;

    /** 使用说明 */
    @Excel(name = "使用说明")
    private String useDescribe;

    /** 使用人 */
    @Excel(name = "使用人")
    private Long useId;

    /** 大写合计 */
    @Excel(name = "大写合计")
    private String capitalTotal;

    /** 小写合计 */
    @Excel(name = "小写合计")
    private BigDecimal littleTotal;

    /** 日利率 */
    @Excel(name = "日利率")
    private BigDecimal dayRate;

    /** 计息日 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "计息日", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date sumInterestDate;

    /** 预计还款日 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "预计还款日", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date expectedRepaymentDate;

    /** 审核人 */
    @Excel(name = "审核人")
    private Long approvalId;

    /** 借贷状态：0待借贷部门确认 1待核算部审核 2完成 3驳回 */
    @Excel(name = "借贷状态：0待借贷部门确认 1待核算部审核 2完成 3驳回")
    private String debitStatus;

    /** 附件 */
    @Excel(name = "附件")
    private String attachmentUrl;

    /** 实际还款日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "实际还款日期", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date realPaymentDate;

    /** 实际还款金额 */
    @Excel(name = "实际还款金额")
    private BigDecimal realPaymentAcount;

    /** 是否删除：0否，1是 */
    @Excel(name = "是否删除：0否，1是")
    private String isDel;

    private String debitDeptName;

    private String operatorName;

    private String lendDeptName;

    private String useName;

    private String approvalName;

    private List<String> operators = new ArrayList<>();

    /**
     * 查询类型
     */
    private String queryType;

    private String lendManageName;

    private Long queryDebitDeptId;

    private Long queryLendDeptId;

    public void setDebitId(Long debitId) 
    {
        this.debitId = debitId;
    }

    public Long getDebitId() 
    {
        return debitId;
    }
    public void setDebitDeptId(Long debitDeptId) 
    {
        this.debitDeptId = debitDeptId;
    }

    public Long getDebitDeptId() 
    {
        return debitDeptId;
    }
    public void setOperatorId(Long operatorId) 
    {
        this.operatorId = operatorId;
    }

    public Long getOperatorId() 
    {
        return operatorId;
    }
    public void setLendDeptId(Long lendDeptId) 
    {
        this.lendDeptId = lendDeptId;
    }

    public Long getLendDeptId() 
    {
        return lendDeptId;
    }
    public void setRegisterTime(Date registerTime) 
    {
        this.registerTime = registerTime;
    }

    public Date getRegisterTime() 
    {
        return registerTime;
    }
    public void setUseDescribe(String useDescribe) 
    {
        this.useDescribe = useDescribe;
    }

    public String getUseDescribe() 
    {
        return useDescribe;
    }
    public void setUseId(Long useId) 
    {
        this.useId = useId;
    }

    public Long getUseId() 
    {
        return useId;
    }
    public void setCapitalTotal(String capitalTotal)
    {
        this.capitalTotal = capitalTotal;
    }

    public String getCapitalTotal()
    {
        return capitalTotal;
    }
    public void setLittleTotal(BigDecimal littleTotal) 
    {
        this.littleTotal = littleTotal;
    }

    public BigDecimal getLittleTotal() 
    {
        return littleTotal;
    }
    public void setDayRate(BigDecimal dayRate) 
    {
        this.dayRate = dayRate;
    }

    public BigDecimal getDayRate() 
    {
        return dayRate;
    }
    public void setSumInterestDate(Date sumInterestDate) 
    {
        this.sumInterestDate = sumInterestDate;
    }

    public Date getSumInterestDate() 
    {
        return sumInterestDate;
    }
    public void setExpectedRepaymentDate(Date expectedRepaymentDate) 
    {
        this.expectedRepaymentDate = expectedRepaymentDate;
    }

    public Date getExpectedRepaymentDate() 
    {
        return expectedRepaymentDate;
    }
    public void setApprovalId(Long approvalId) 
    {
        this.approvalId = approvalId;
    }

    public Long getApprovalId() 
    {
        return approvalId;
    }
    public void setDebitStatus(String debitStatus) 
    {
        this.debitStatus = debitStatus;
    }

    public String getDebitStatus() 
    {
        return debitStatus;
    }
    public void setAttachmentUrl(String attachmentUrl) 
    {
        this.attachmentUrl = attachmentUrl;
    }

    public String getAttachmentUrl() 
    {
        return attachmentUrl;
    }
    public void setRealPaymentDate(Date realPaymentDate) 
    {
        this.realPaymentDate = realPaymentDate;
    }

    public Date getRealPaymentDate() 
    {
        return realPaymentDate;
    }
    public void setRealPaymentAcount(BigDecimal realPaymentAcount)
    {
        this.realPaymentAcount = realPaymentAcount;
    }

    public BigDecimal getRealPaymentAcount()
    {
        return realPaymentAcount;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getDebitDeptName() {
        return debitDeptName;
    }

    public void setDebitDeptName(String debitDeptName) {
        this.debitDeptName = debitDeptName;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getLendDeptName() {
        return lendDeptName;
    }

    public void setLendDeptName(String lendDeptName) {
        this.lendDeptName = lendDeptName;
    }

    public String getUseName() {
        return useName;
    }

    public void setUseName(String useName) {
        this.useName = useName;
    }

    public String getApprovalName() {
        return approvalName;
    }

    public void setApprovalName(String approvalName) {
        this.approvalName = approvalName;
    }

    public List<String> getOperators() {
        return operators;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public String getQueryType() {
        return queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public Long getLendDeptManageId() {
        return lendDeptManageId;
    }

    public void setLendDeptManageId(Long lendDeptManageId) {
        this.lendDeptManageId = lendDeptManageId;
    }

    public String getLendManageName() {
        return lendManageName;
    }

    public void setLendManageName(String lendManageName) {
        this.lendManageName = lendManageName;
    }

    public Long getQueryDebitDeptId() {
        return queryDebitDeptId;
    }

    public void setQueryDebitDeptId(Long queryDebitDeptId) {
        this.queryDebitDeptId = queryDebitDeptId;
    }

    public Long getQueryLendDeptId() {
        return queryLendDeptId;
    }

    public void setQueryLendDeptId(Long queryLendDeptId) {
        this.queryLendDeptId = queryLendDeptId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("debitId", getDebitId())
            .append("debitDeptId", getDebitDeptId())
            .append("operatorId", getOperatorId())
            .append("lendDeptId", getLendDeptId())
            .append("registerTime", getRegisterTime())
            .append("useDescribe", getUseDescribe())
            .append("useId", getUseId())
            .append("capitalTotal", getCapitalTotal())
            .append("littleTotal", getLittleTotal())
            .append("dayRate", getDayRate())
            .append("sumInterestDate", getSumInterestDate())
            .append("expectedRepaymentDate", getExpectedRepaymentDate())
            .append("approvalId", getApprovalId())
            .append("debitStatus", getDebitStatus())
            .append("attachmentUrl", getAttachmentUrl())
            .append("realPaymentDate", getRealPaymentDate())
            .append("realPaymentAcount", getRealPaymentAcount())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
