package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 资金操作对象 t_cash_operate
 *
 * @author zehong
 * @date 2023-06-06
 */
public class TCashOperate extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 操作id */
    private Long operateId;

    /** 操作部门id */
    @Excel(name = "操作部门id")
    private Long operateDeptId;

    /** 操作类型 */
    @Excel(name = "操作类型")
    private String operateType;

    /** 操作金额 */
    @Excel(name = "操作金额")
    private BigDecimal operateAmount;

    /** 关联单据 */
    @Excel(name = "关联单据")
    private String relationDoc;

    /** 操作时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date operateTime;

    /** 是否删除：0否，1是 */
    @Excel(name = "是否删除：0否，1是")
    private String isDel;

    private String operateDeptName;

    public String getDocumentType() {
        return documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    private String documentType;

    public void setOperateId(Long operateId)
    {
        this.operateId = operateId;
    }

    public Long getOperateId()
    {
        return operateId;
    }
    public void setOperateDeptId(Long operateDeptId)
    {
        this.operateDeptId = operateDeptId;
    }

    public Long getOperateDeptId()
    {
        return operateDeptId;
    }
    public void setOperateType(String operateType)
    {
        this.operateType = operateType;
    }

    public String getOperateType()
    {
        return operateType;
    }
    public void setOperateAmount(BigDecimal operateAmount)
    {
        this.operateAmount = operateAmount;
    }

    public BigDecimal getOperateAmount()
    {
        return operateAmount;
    }
    public void setRelationDoc(String relationDoc)
    {
        this.relationDoc = relationDoc;
    }

    public String getRelationDoc()
    {
        return relationDoc;
    }
    public void setOperateTime(Date operateTime)
    {
        this.operateTime = operateTime;
    }

    public Date getOperateTime()
    {
        return operateTime;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    public String getOperateDeptName() {
        return operateDeptName;
    }

    public void setOperateDeptName(String operateDeptName) {
        this.operateDeptName = operateDeptName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("operateId", getOperateId())
            .append("operateDeptId", getOperateDeptId())
            .append("operateType", getOperateType())
            .append("operateAmount", getOperateAmount())
            .append("relationDoc", getRelationDoc())
            .append("operateTime", getOperateTime())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
