package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 借支申请对象 t_borrowing_apply_for
 *
 * @author zehong
 * @date 2023-06-15
 */
public class TBorrowingApplyFor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 借支主键id */
    private Long borrowing;

    /** 费用名称 */
    @Excel(name = "费用名称")
    private String feeName;

    /** 借支部门id */
    @Excel(name = "借支部门id")
    private Long borrowingDeptId;

    /** 经办人id */
    @Excel(name = "经办人id")
    private Long handledByUserId;

    /** 用途说明 */
    @Excel(name = "用途说明")
    private String applicationDescription;

    /** 使用人id */
    @Excel(name = "使用人id")
    private Long userId;

    /** 大写合计 */
    @Excel(name = "大写合计")
    private String totalWords;

    /** 小写合计 */
    @Excel(name = "小写合计")
    private BigDecimal totalFigures;

    /** 审批人id */
    @Excel(name = "审批人id")
    private Long approvedUserId;

    /** 登记日期 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "登记日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date registrationDate;

    /** 附件 */
    @Excel(name = "附件")
    private String attachmentUrl;

    /** 是否删除 0未删除 1删除 */
    @Excel(name = "是否删除 0未删除 1删除")
    private String isDel;

    /**审批状态  1未审批   2通过   3驳回 */
    private Integer approvalStatus;

    private String deptName;

    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "登记日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date approvalTime;


    public Date getApprovalTime() {
        return approvalTime;
    }

    public void setApprovalTime(Date approvalTime) {
        this.approvalTime = approvalTime;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    private String handledByUserIdName;

    private String userIdName;

    private String ApprovedUserIdName;

    public String getHandledByUserIdName() {
        return handledByUserIdName;
    }

    public void setHandledByUserIdName(String handledByUserIdName) {
        this.handledByUserIdName = handledByUserIdName;
    }

    public String getUserIdName() {
        return userIdName;
    }

    public void setUserIdName(String userIdName) {
        this.userIdName = userIdName;
    }

    public String getApprovedUserIdName() {
        return ApprovedUserIdName;
    }

    public void setApprovedUserIdName(String approvedUserIdName) {
        ApprovedUserIdName = approvedUserIdName;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Integer getApprovalStatus() {
        return approvalStatus;
    }

    public void setApprovalStatus(Integer approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public void setBorrowing(Long borrowing)
    {
        this.borrowing = borrowing;
    }

    public Long getBorrowing()
    {
        return borrowing;
    }
    public void setFeeName(String feeName)
    {
        this.feeName = feeName;
    }

    public String getFeeName()
    {
        return feeName;
    }
    public void setBorrowingDeptId(Long borrowingDeptId)
    {
        this.borrowingDeptId = borrowingDeptId;
    }

    public Long getBorrowingDeptId()
    {
        return borrowingDeptId;
    }
    public void setHandledByUserId(Long handledByUserId)
    {
        this.handledByUserId = handledByUserId;
    }

    public Long getHandledByUserId()
    {
        return handledByUserId;
    }
    public void setApplicationDescription(String applicationDescription)
    {
        this.applicationDescription = applicationDescription;
    }

    public String getApplicationDescription()
    {
        return applicationDescription;
    }
    public void setUserId(Long userId)
    {
        this.userId = userId;
    }

    public Long getUserId()
    {
        return userId;
    }
    public void setTotalWords(String totalWords)
    {
        this.totalWords = totalWords;
    }

    public String getTotalWords()
    {
        return totalWords;
    }
    public void setTotalFigures(BigDecimal totalFigures)
    {
        this.totalFigures = totalFigures;
    }

    public BigDecimal getTotalFigures()
    {
        return totalFigures;
    }
    public void setApprovedUserId(Long approvedUserId)
    {
        this.approvedUserId = approvedUserId;
    }

    public Long getApprovedUserId()
    {
        return approvedUserId;
    }
    public void setRegistrationDate(Date registrationDate)
    {
        this.registrationDate = registrationDate;
    }

    public Date getRegistrationDate()
    {
        return registrationDate;
    }
    public void setAttachmentUrl(String attachmentUrl)
    {
        this.attachmentUrl = attachmentUrl;
    }

    public String getAttachmentUrl()
    {
        return attachmentUrl;
    }
    public void setIsDel(String isDel)
    {
        this.isDel = isDel;
    }

    public String getIsDel()
    {
        return isDel;
    }

    @Override
    public String toString() {
        return "TBorrowingApplyFor{" +
                "borrowing=" + borrowing +
                ", feeName='" + feeName + '\'' +
                ", borrowingDeptId=" + borrowingDeptId +
                ", handledByUserId=" + handledByUserId +
                ", applicationDescription='" + applicationDescription + '\'' +
                ", userId=" + userId +
                ", totalWords='" + totalWords + '\'' +
                ", totalFigures=" + totalFigures +
                ", approvedUserId=" + approvedUserId +
                ", registrationDate=" + registrationDate +
                ", attachmentUrl='" + attachmentUrl + '\'' +
                ", isDel='" + isDel + '\'' +
                ", approvalStatus=" + approvalStatus +
                ", deptName='" + deptName + '\'' +
                ", approvalTime=" + approvalTime +
                ", handledByUserIdName='" + handledByUserIdName + '\'' +
                ", userIdName='" + userIdName + '\'' +
                ", ApprovedUserIdName='" + ApprovedUserIdName + '\'' +
                '}';
    }
}
