package com.zehong.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 账户对象 t_account
 * 
 * @author zehong
 * @date 2023-06-06
 */
public class TAccount extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 账户主键 */
    private Long accountId;

    /** 部门 */
    @Excel(name = "部门")
    private Long deptId;

    /**账户总额*/
    private BigDecimal totalAmount;

    /** 可用金额 */
    @Excel(name = "可用金额")
    private BigDecimal ableAmount;

    /**应收总额*/
    private BigDecimal incomeAbleTotalAmount;

    /**应付总额*/
    private BigDecimal payableTotalAmount;

    /** 是否删除：0否，1是 */
    @Excel(name = "是否删除：0否，1是")
    private String isDel;

    private String deptName;

    public void setAccountId(Long accountId) 
    {
        this.accountId = accountId;
    }

    public Long getAccountId() 
    {
        return accountId;
    }
    public void setDeptId(Long deptId) 
    {
        this.deptId = deptId;
    }

    public Long getDeptId() 
    {
        return deptId;
    }
    public void setAbleAmount(BigDecimal ableAmount) 
    {
        this.ableAmount = ableAmount;
    }

    public BigDecimal getAbleAmount() 
    {
        return ableAmount;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getIncomeAbleTotalAmount() {
        return incomeAbleTotalAmount;
    }

    public void setIncomeAbleTotalAmount(BigDecimal incomeAbleTotalAmount) {
        this.incomeAbleTotalAmount = incomeAbleTotalAmount;
    }

    public BigDecimal getPayableTotalAmount() {
        return payableTotalAmount;
    }

    public void setPayableTotalAmount(BigDecimal payableTotalAmount) {
        this.payableTotalAmount = payableTotalAmount;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("accountId", getAccountId())
            .append("deptId", getDeptId())
            .append("ableAmount", getAbleAmount())
            .append("createTime", getCreateTime())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remark", getRemark())
            .toString();
    }
}
