package com.zehong.web.controller.transaction;

import java.util.Date;
import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.framework.web.service.TokenService;
import com.zehong.system.domain.TCashOperate;
import com.zehong.system.service.ITCashOperateService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TBorrowingApplyFor;
import com.zehong.system.service.ITBorrowingApplyForService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 借支申请Controller
 *
 * @author zehong
 * @date 2023-06-15
 */
@RestController
@RequestMapping("/system/for")
public class TBorrowingApplyForController extends BaseController
{
    @Autowired
    private ITBorrowingApplyForService tBorrowingApplyForService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private ITCashOperateService tCashOperateService;
    /**
     * 查询借支申请列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TBorrowingApplyFor tBorrowingApplyFor)
    {
        SysUser user = tokenService.getLoginUser(ServletUtils.getRequest()).getUser();
        int permission=0;
        for (int i=0;i<user.getRoles().size();i++){
            if ("calculator".equals(user.getRoles().get(i).getRoleKey())){
                permission=1;
            }
        }
        if (!"核算部".equals(user.getDept().getDeptName())){
            tBorrowingApplyFor.setBorrowingDeptId(user.getDeptId());
        }
        startPage();
        List<TBorrowingApplyFor> list = tBorrowingApplyForService.selectTBorrowingApplyForList(tBorrowingApplyFor);
        return getDataTableT(list,permission);
    }

    /**
     * 导出借支申请列表
     */
    @PreAuthorize("@ss.hasPermi('system:for:export')")
    @Log(title = "借支申请", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TBorrowingApplyFor tBorrowingApplyFor)
    {
        List<TBorrowingApplyFor> list = tBorrowingApplyForService.selectTBorrowingApplyForList(tBorrowingApplyFor);
        ExcelUtil<TBorrowingApplyFor> util = new ExcelUtil<TBorrowingApplyFor>(TBorrowingApplyFor.class);
        return util.exportExcel(list, "借支申请数据");
    }

    /**
     * 获取借支申请详细信息
     */
    @GetMapping(value = "/{borrowing}")
    public AjaxResult getInfo(@PathVariable("borrowing") Long borrowing)
    {
        return AjaxResult.success(tBorrowingApplyForService.selectTBorrowingApplyForById(borrowing));
    }

    /**
     * 新增借支申请
     */
    @Log(title = "借支申请", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TBorrowingApplyFor tBorrowingApplyFor)
    {

        // 获取当前用户
        SysUser user = tokenService.getLoginUser(ServletUtils.getRequest()).getUser();
        if (StringUtils.isNotNull(user)) {
            tBorrowingApplyFor.setHandledByUserId(user.getUserId());
            //设置经办人部门
            tBorrowingApplyFor.setBorrowingDeptId(user.getDeptId());
            //设置审批状态
            tBorrowingApplyFor.setApprovalStatus(1);
        }
        tBorrowingApplyFor.setRegistrationDate(new Date());
        return toAjax(tBorrowingApplyForService.insertTBorrowingApplyFor(tBorrowingApplyFor));
    }

    /**
     * 查询部门余额是否足够
     * @param tBorrowingApplyFor
     * @return
     */
    @GetMapping("/departmentBalance")
    public int departmentBalance(TBorrowingApplyFor tBorrowingApplyFor){
        SysUser user = tokenService.getLoginUser(ServletUtils.getRequest()).getUser();
        tBorrowingApplyFor.setApprovedUserId(user.getUserId());
        /**查询部门余额是否足够*/
        int isSufficient = tBorrowingApplyForService.selectTacc(tBorrowingApplyFor);
        //0部门余额不足 1余额足够
        if (isSufficient!=0){
            return 1;
        }else {
            return 2;
        }
    }


    /**
     * 修改借支申请
     */
    @Log(title = "借支申请", businessType = BusinessType.UPDATE)
    @PutMapping
    public int edit(@RequestBody TBorrowingApplyFor tBorrowingApplyFor)
    {
        tBorrowingApplyFor.setApprovalTime(new Date());
        SysUser user = tokenService.getLoginUser(ServletUtils.getRequest()).getUser();
        tBorrowingApplyFor.setApprovedUserId(user.getUserId());
        if (tBorrowingApplyFor.getApprovalStatus()==3){
            //修改借支申请表状态
            tBorrowingApplyForService.updateTBorrowingApplyFor(tBorrowingApplyFor);
            return 3;
        }
        /**查询部门余额是否足够*/
        int isSufficient = tBorrowingApplyForService.selectTacc(tBorrowingApplyFor);
        //0部门余额不足 1余额足够
        if (isSufficient!=0){
            tBorrowingApplyFor.setApprovalTime(new Date());
            //修改部门余额
            tBorrowingApplyForService.deletebBalance(tBorrowingApplyFor);
            //修改借支申请表状态
            tBorrowingApplyForService.updateTBorrowingApplyFor(tBorrowingApplyFor);
            TCashOperate tCashOperate=new TCashOperate();
            tCashOperate.setOperateDeptId(tBorrowingApplyFor.getBorrowingDeptId());
            tCashOperate.setOperateType("2");
            tCashOperate.setOperateAmount(tBorrowingApplyFor.getTotalFigures());
            tCashOperate.setIsDel("0");
            tCashOperate.setDocumentType("2");
            tCashOperate.setRelationDoc(String.valueOf(tBorrowingApplyFor.getBorrowing()));
            tCashOperate.setOperateTime(new Date());
             //增加资金操作记录
            tCashOperateService.insertTCashOperate(tCashOperate);
            return 1;
        }else {
//            tBorrowingApplyFor.setApprovalStatus(3);
            //修改借支申请表状态
//            tBorrowingApplyForService.updateTBorrowingApplyFor(tBorrowingApplyFor);
            return 2;
        }

    }

    /**
     * 删除借支申请
     */
    @Log(title = "借支申请", businessType = BusinessType.DELETE)
	@DeleteMapping("/{borrowings}")
    public AjaxResult remove(@PathVariable Long[] borrowings)
    {
        return toAjax(tBorrowingApplyForService.deleteTBorrowingApplyForByIds(borrowings));
    }
}
