package com.zehong.web.controller.account;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TCashOperate;
import com.zehong.system.service.ITCashOperateService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 资金操作Controller
 * 
 * @author zehong
 * @date 2023-06-06
 */
@RestController
@RequestMapping("/system/operate")
public class TCashOperateController extends BaseController
{
    @Autowired
    private ITCashOperateService tCashOperateService;

    /**
     * 查询资金操作列表
     */
//    @PreAuthorize("@ss.hasPermi('system:operate:list')")
    @GetMapping("/list")
    public TableDataInfo list(TCashOperate tCashOperate)
    {
        startPage();
        List<TCashOperate> list = tCashOperateService.selectTCashOperateList(tCashOperate);
        return getDataTable(list);
    }

    /**
     * 导出资金操作列表
     */
    @PreAuthorize("@ss.hasPermi('system:operate:export')")
    @Log(title = "资金操作", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TCashOperate tCashOperate)
    {
        List<TCashOperate> list = tCashOperateService.selectTCashOperateList(tCashOperate);
        ExcelUtil<TCashOperate> util = new ExcelUtil<TCashOperate>(TCashOperate.class);
        return util.exportExcel(list, "资金操作数据");
    }

    /**
     * 获取资金操作详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:operate:query')")
    @GetMapping(value = "/{operateId}")
    public AjaxResult getInfo(@PathVariable("operateId") Long operateId)
    {
        return AjaxResult.success(tCashOperateService.selectTCashOperateById(operateId));
    }

    /**
     * 新增资金操作
     */
    @PreAuthorize("@ss.hasPermi('system:operate:add')")
    @Log(title = "资金操作", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TCashOperate tCashOperate)
    {
        return toAjax(tCashOperateService.insertTCashOperate(tCashOperate));
    }

    /**
     * 修改资金操作
     */
    @PreAuthorize("@ss.hasPermi('system:operate:edit')")
    @Log(title = "资金操作", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TCashOperate tCashOperate)
    {
        return toAjax(tCashOperateService.updateTCashOperate(tCashOperate));
    }

    /**
     * 删除资金操作
     */
    @PreAuthorize("@ss.hasPermi('system:operate:remove')")
    @Log(title = "资金操作", businessType = BusinessType.DELETE)
	@DeleteMapping("/{operateIds}")
    public AjaxResult remove(@PathVariable Long[] operateIds)
    {
        return toAjax(tCashOperateService.deleteTCashOperateByIds(operateIds));
    }
}
