package com.zehong.web.controller.account;

import java.util.List;

import com.zehong.common.core.domain.entity.SysUser;
import com.zehong.common.utils.ServletUtils;
import com.zehong.common.utils.StringUtils;
import com.zehong.framework.web.service.TokenService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TAccount;
import com.zehong.system.service.ITAccountService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 账户Controller
 * 
 * @author zehong
 * @date 2023-06-05
 */
@RestController
@RequestMapping("/system/account")
public class TAccountController extends BaseController
{
    @Autowired
    private ITAccountService tAccountService;
    @Autowired
    private TokenService tokenService;

    /**
     * 查询账户列表
     */
    @PreAuthorize("@ss.hasPermi('system:account:list')")
    @GetMapping("/list")
    public TableDataInfo list(TAccount tAccount)
    {
        startPage();
        // 获取当前用户
        SysUser user = tokenService.getLoginUser(ServletUtils.getRequest()).getUser();
        if (StringUtils.isNotNull(user) && !user.isAdmin()) {
            tAccount.setDeptId(user.getDeptId());
        }
        List<TAccount> list = tAccountService.selectTAccountList(tAccount);
        return getDataTable(list);
    }

    /**
     * 导出账户列表
     */
    @PreAuthorize("@ss.hasPermi('system:account:export')")
    @Log(title = "账户", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TAccount tAccount)
    {
        List<TAccount> list = tAccountService.selectTAccountList(tAccount);
        ExcelUtil<TAccount> util = new ExcelUtil<TAccount>(TAccount.class);
        return util.exportExcel(list, "账户数据");
    }

    /**
     * 获取账户详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:account:query')")
    @GetMapping(value = "/{accountId}")
    public AjaxResult getInfo(@PathVariable("accountId") Long accountId)
    {
        return AjaxResult.success(tAccountService.selectTAccountById(accountId));
    }

    /**
     * 新增账户
     */
    @PreAuthorize("@ss.hasPermi('system:account:add')")
    @Log(title = "账户", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TAccount tAccount)
    {
        return toAjax(tAccountService.insertTAccount(tAccount));
    }

    /**
     * 修改账户
     */
    @PreAuthorize("@ss.hasPermi('system:account:edit')")
    @Log(title = "账户", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TAccount tAccount)
    {
        return toAjax(tAccountService.updateTAccount(tAccount));
    }

    /**
     * 删除账户
     */
    @PreAuthorize("@ss.hasPermi('system:account:remove')")
    @Log(title = "账户", businessType = BusinessType.DELETE)
	@DeleteMapping("/{accountIds}")
    public AjaxResult remove(@PathVariable Long[] accountIds)
    {
        return toAjax(tAccountService.deleteTAccountByIds(accountIds));
    }
}
