import request from '@/utils/request'

// 查询考勤打卡列表
export function listIn(query) {
  return request({
    url: '/system/in/list',
    method: 'get',
    params: query
  })
}

// 查询考勤打卡详细
export function getIn(id) {
  return request({
    url: '/system/in/' + id,
    method: 'get'
  })
}

// 新增考勤打卡
export function addIn(data) {
  return request({
    url: '/system/in',
    method: 'post',
    data: data
  })
}

// 修改考勤打卡
export function updateIn(data) {
  return request({
    url: '/system/in',
    method: 'put',
    data: data
  })
}

// 删除考勤打卡
export function delIn(id) {
  return request({
    url: '/system/in/' + id,
    method: 'delete'
  })
}

// 导出考勤打卡
export function exportIn(query) {
  return request({
    url: '/system/in/export',
    method: 'get',
    params: query
  })
}