import request from '@/utils/request'

// 查询特殊作业单列表
export function listDocument(query) {
  return request({
    url: '/workPermit/document/list',
    method: 'get',
    params: query
  })
}

// 查询特殊作业单详细
export function getDocument(id) {
  return request({
    url: '/workPermit/document/' + id,
    method: 'get'
  })
}

// 新增特殊作业单
export function addDocument(data) {
  return request({
    url: '/workPermit/document',
    method: 'post',
    data: data
  })
}

// 修改特殊作业单
export function updateDocument(data) {
  return request({
    url: '/workPermit/document',
    method: 'put',
    data: data
  })
}

// 删除特殊作业单
export function delDocument(id) {
  return request({
    url: '/workPermit/document/' + id,
    method: 'delete'
  })
}

// 导出特殊作业单
export function exportDocument(query) {
  return request({
    url: '/workPermit/document/export',
    method: 'get',
    params: query
  })
}
