import request from '@/utils/request'

// 查询管线巡线人员分配列表
export function listUser(query) {
  return request({
    url: '/linePatrol/user/list',
    method: 'get',
    params: query
  })
}

//全部信息
export function pipeUserList(query) {
  return request({
    url: '/linePatrol/user/pipeUserList',
    method: 'get',
    params: query
  })
}

// 查询管线巡线人员分配详细
export function getUser(id) {
  return request({
    url: '/linePatrol/user/' + id,
    method: 'get'
  })
}

// 新增管线巡线人员分配
export function addUser(data) {
  return request({
    url: '/linePatrol/user',
    method: 'post',
    data: data
  })
}

// 修改管线巡线人员分配
export function updateUser(data) {
  return request({
    url: '/linePatrol/user',
    method: 'put',
    data: data
  })
}

// 删除管线巡线人员分配
export function delUser(id) {
  return request({
    url: '/linePatrol/user/' + id,
    method: 'delete'
  })
}

// 导出管线巡线人员分配
export function exportUser(query) {
  return request({
    url: '/linePatrol/user/export',
    method: 'get',
    params: query
  })
}

export function deleteTPipeUserByUserIdAndPipeId(query){
  return request({
    url: '/linePatrol/user/deleteTPipeUserByUserIdAndPipeId',
    method: 'get',
    params: query
  })
}
