import request from '@/utils/request'

// 查询场站巡检任务列表
export function listTask(query) {
  return request({
    url: '/site/task/list',
    method: 'get',
    params: query
  })
}

// 查询场站巡检任务详细
export function getTask(id) {
  return request({
    url: '/site/task/' + id,
    method: 'get'
  })
}

// 新增场站巡检任务
export function addTask(data) {
  return request({
    url: '/site/task',
    method: 'post',
    data: data
  })
}

// 修改场站巡检任务
export function updateTask(data) {
  return request({
    url: '/site/task',
    method: 'put',
    data: data
  })
}

// 删除场站巡检任务
export function delTask(id) {
  return request({
    url: '/site/task/' + id,
    method: 'delete'
  })
}

// 导出场站巡检任务
export function exportTask(query) {
  return request({
    url: '/site/task/export',
    method: 'get',
    params: query
  })
}
