import request from '@/utils/request'

// 查询居民用户列表
export function listUser(query) {
  return request({
    url: '/system/jmuser/list',
    method: 'get',
    params: query
  })
}

// 查询居民用户详细
export function getUser(id) {
  return request({
    url: '/system/jmuser/' + id,
    method: 'get'
  })
}

// 新增居民用户
export function addUser(data) {
  return request({
    url: '/system/jmuser',
    method: 'post',
    data: data
  })
}

// 修改居民用户
export function updateUser(data) {
  return request({
    url: '/system/jmuser',
    method: 'put',
    data: data
  })
}

// 删除居民用户
export function delUser(id) {
  return request({
    url: '/system/jmuser/' + id,
    method: 'delete'
  })
}

// 导出居民用户
export function exportUser(query) {
  return request({
    url: '/system/jmuser/export',
    method: 'get',
    params: query
  })
}
