package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TUserMapper;
import com.zehong.system.domain.TUser;
import com.zehong.system.service.ITUserService;

/**
 * 居民用户Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-03
 */
@Service
public class TUserServiceImpl implements ITUserService 
{
    @Autowired
    private TUserMapper tUserMapper;

    /**
     * 查询居民用户
     * 
     * @param id 居民用户ID
     * @return 居民用户
     */
    @Override
    public TUser selectTUserById(Long id)
    {
        TUser u =  tUserMapper.selectTUserById(id);
        if(u.getDevice()!=null&&!u.getDevice().equals("")){
            u.setDeviceName(tUserMapper.selectDeviceName(u.getDevice().split(",")));
        }
        return u;
    }

    /**
     * 查询居民用户列表
     * 
     * @param tUser 居民用户
     * @return 居民用户
     */
    @Override
    public List<TUser> selectTUserList(TUser tUser)
    {
        return tUserMapper.selectTUserList(tUser);
    }

    /**
     * 新增居民用户
     * 
     * @param tUser 居民用户
     * @return 结果
     */
    @Override
    public int insertTUser(TUser tUser)
    {
        tUser.setCreateTime(new Date());
        return tUserMapper.insertTUser(tUser);
    }

    /**
     * 修改居民用户
     * 
     * @param tUser 居民用户
     * @return 结果
     */
    @Override
    public int updateTUser(TUser tUser)
    {
        return tUserMapper.updateTUser(tUser);
    }

    /**
     * 批量删除居民用户
     * 
     * @param ids 需要删除的居民用户ID
     * @return 结果
     */
    @Override
    public int deleteTUserByIds(Long[] ids)
    {
        return tUserMapper.deleteTUserByIds(ids);
    }

    /**
     * 删除居民用户信息
     * 
     * @param id 居民用户ID
     * @return 结果
     */
    @Override
    public int deleteTUserById(Long id)
    {
        return tUserMapper.deleteTUserById(id);
    }
}
