package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPipeTaskUserMapper;
import com.zehong.system.domain.TPipeTaskUser;
import com.zehong.system.service.ITPipeTaskUserService;

/**
 * 管线巡检起止Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-17
 */
@Service
public class TPipeTaskUserServiceImpl implements ITPipeTaskUserService 
{
    @Autowired
    private TPipeTaskUserMapper tPipeTaskUserMapper;

    /**
     * 查询管线巡检起止
     * 
     * @param id 管线巡检起止ID
     * @return 管线巡检起止
     */
    @Override
    public TPipeTaskUser selectTPipeTaskUserById(Long id)
    {
        return tPipeTaskUserMapper.selectTPipeTaskUserById(id);
    }

    /**
     * 查询管线巡检起止列表
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 管线巡检起止
     */
    @Override
    public List<TPipeTaskUser> selectTPipeTaskUserList(TPipeTaskUser tPipeTaskUser)
    {
        return tPipeTaskUserMapper.selectTPipeTaskUserList(tPipeTaskUser);
    }

    /**
     * 新增管线巡检起止
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 结果
     */
    @Override
    public int insertTPipeTaskUser(TPipeTaskUser tPipeTaskUser)
    {
        tPipeTaskUser.setCreateTime(DateUtils.getNowDate());
        return tPipeTaskUserMapper.insertTPipeTaskUser(tPipeTaskUser);
    }

    /**
     * 开始结束巡检
     * @param tPipeTaskUser
     * @return
     */
    @Override
    public int updateStatus(TPipeTaskUser tPipeTaskUser)
    {
        TPipeTaskUser  tp = tPipeTaskUserMapper.selectByuserIdTaskId(tPipeTaskUser.getUserId(),tPipeTaskUser.getPipeTaskId());
        if(tp==null){
            tPipeTaskUser.setCreateTime(DateUtils.getNowDate());
            return tPipeTaskUserMapper.insertTPipeTaskUser(tPipeTaskUser);
        }else {
            tp.setStatus(tPipeTaskUser.getStatus());
            if(tPipeTaskUser.getStatus()==0){
                tp.setEndTime(new Date());
            }
            return tPipeTaskUserMapper.updateTPipeTaskUser(tp);
        }
    }


    /**
     * 修改管线巡检起止
     * 
     * @param tPipeTaskUser 管线巡检起止
     * @return 结果
     */
    @Override
    public int updateTPipeTaskUser(TPipeTaskUser tPipeTaskUser)
    {
        return tPipeTaskUserMapper.updateTPipeTaskUser(tPipeTaskUser);
    }

    /**
     * 批量删除管线巡检起止
     * 
     * @param ids 需要删除的管线巡检起止ID
     * @return 结果
     */
    @Override
    public int deleteTPipeTaskUserByIds(Long[] ids)
    {
        return tPipeTaskUserMapper.deleteTPipeTaskUserByIds(ids);
    }

    /**
     * 删除管线巡检起止信息
     * 
     * @param id 管线巡检起止ID
     * @return 结果
     */
    @Override
    public int deleteTPipeTaskUserById(Long id)
    {
        return tPipeTaskUserMapper.deleteTPipeTaskUserById(id);
    }
}
