package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPipeInfoMapper;
import com.zehong.system.domain.TPipeInfo;
import com.zehong.system.service.ITPipeInfoService;

/**
 * 管道信息Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-02
 */
@Service
public class TPipeInfoServiceImpl implements ITPipeInfoService 
{
    @Autowired
    private TPipeInfoMapper tPipeInfoMapper;

    /**
     * 查询管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    @Override
    public TPipeInfo selectTPipeInfoById(Long pipeId)
    {
        return tPipeInfoMapper.selectTPipeInfoById(pipeId);
    }

    /**
     * 查询管道信息列表
     * 
     * @param tPipeInfo 管道信息
     * @return 管道信息
     */
    @Override
    public List<TPipeInfo> selectTPipeInfoList(TPipeInfo tPipeInfo)
    {
        return tPipeInfoMapper.selectTPipeInfoList(tPipeInfo);
    }

    /**
     * 新增管道信息
     * 
     * @param tPipeInfo 管道信息
     * @return 结果
     */
    @Override
    public int insertTPipeInfo(TPipeInfo tPipeInfo)
    {
        tPipeInfo.setCreateTime(DateUtils.getNowDate());
        return tPipeInfoMapper.insertTPipeInfo(tPipeInfo);
    }

    /**
     * 修改管道信息
     * 
     * @param tPipeInfo 管道信息
     * @return 结果
     */
    @Override
    public int updateTPipeInfo(TPipeInfo tPipeInfo)
    {
        tPipeInfo.setUpdateTime(DateUtils.getNowDate());
        return tPipeInfoMapper.updateTPipeInfo(tPipeInfo);
    }

    /**
     * 批量删除管道信息
     * 
     * @param pipeIds 需要删除的管道信息ID
     * @return 结果
     */
    @Override
    public int deleteTPipeInfoByIds(Long[] pipeIds)
    {
        return tPipeInfoMapper.deleteTPipeInfoByIds(pipeIds);
    }

    /**
     * 删除管道信息信息
     * 
     * @param pipeId 管道信息ID
     * @return 结果
     */
    @Override
    public int deleteTPipeInfoById(Long pipeId)
    {
        return tPipeInfoMapper.deleteTPipeInfoById(pipeId);
    }

    /**
     * 根据巡线查询管道信息
     * @param tPipeInfo 管道信息
     * @return
     */
    @Override
    public List<TPipeInfo> selectPipeInfoByUser(TPipeInfo tPipeInfo){
        return tPipeInfoMapper.selectPipeInfoByUser(tPipeInfo);
    }
}
