package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMapDotMapper;
import com.zehong.system.domain.TMapDot;
import com.zehong.system.service.ITMapDotService;

/**
 * 地图打点Service业务层处理
 * 
 * @author zehong
 * @date 2024-01-17
 */
@Service
public class TMapDotServiceImpl implements ITMapDotService{
    @Autowired
    private TMapDotMapper tMapDotMapper;

    /**
     * 查询地图打点
     * 
     * @param id 地图打点ID
     * @return 地图打点
     */
    @Override
    public TMapDot selectTMapDotById(Long id)
    {
        return tMapDotMapper.selectTMapDotById(id);
    }

    /**
     * 查询地图打点列表
     * 
     * @param tMapDot 地图打点
     * @return 地图打点
     */
    @Override
    public List<TMapDot> selectTMapDotList(TMapDot tMapDot)
    {
        return tMapDotMapper.selectTMapDotList(tMapDot);
    }

    /**
     * 新增地图打点
     * 
     * @param tMapDot 地图打点
     * @return 结果
     */
    @Override
    public int insertTMapDot(TMapDot tMapDot)
    {
        tMapDot.setCreateTime(DateUtils.getNowDate());
        return tMapDotMapper.insertTMapDot(tMapDot);
    }

    /**
     * 修改地图打点
     * 
     * @param tMapDot 地图打点
     * @return 结果
     */
    @Override
    public int updateTMapDot(TMapDot tMapDot)
    {
        return tMapDotMapper.updateTMapDot(tMapDot);
    }

    /**
     * 批量删除地图打点
     * 
     * @param ids 需要删除的地图打点ID
     * @return 结果
     */
    @Override
    public int deleteTMapDotByIds(Long[] ids)
    {
        return tMapDotMapper.deleteTMapDotByIds(ids);
    }

    /**
     * 删除地图打点信息
     * 
     * @param id 地图打点ID
     * @return 结果
     */
    @Override
    public int deleteTMapDotById(Long id)
    {
        return tMapDotMapper.deleteTMapDotById(id);
    }
}
