package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TFailureMapper;
import com.zehong.system.domain.TFailure;
import com.zehong.system.service.ITFailureService;

/**
 * 事故台账Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-20
 */
@Service
public class TFailureServiceImpl implements ITFailureService 
{
    @Autowired
    private TFailureMapper tFailureMapper;

    /**
     * 查询事故台账
     * 
     * @param id 事故台账ID
     * @return 事故台账
     */
    @Override
    public TFailure selectTFailureById(Long id)
    {
        return tFailureMapper.selectTFailureById(id);
    }

    /**
     * 查询事故台账列表
     * 
     * @param tFailure 事故台账
     * @return 事故台账
     */
    @Override
    public List<TFailure> selectTFailureList(TFailure tFailure)
    {
        return tFailureMapper.selectTFailureList(tFailure);
    }

    /**
     * 新增事故台账
     * 
     * @param tFailure 事故台账
     * @return 结果
     */
    @Override
    public int insertTFailure(TFailure tFailure)
    {
        tFailure.setCreateTime(DateUtils.getNowDate());
        return tFailureMapper.insertTFailure(tFailure);
    }

    /**
     * 修改事故台账
     * 
     * @param tFailure 事故台账
     * @return 结果
     */
    @Override
    public int updateTFailure(TFailure tFailure)
    {
        return tFailureMapper.updateTFailure(tFailure);
    }

    /**
     * 批量删除事故台账
     * 
     * @param ids 需要删除的事故台账ID
     * @return 结果
     */
    @Override
    public int deleteTFailureByIds(Long[] ids)
    {
        return tFailureMapper.deleteTFailureByIds(ids);
    }

    /**
     * 删除事故台账信息
     * 
     * @param id 事故台账ID
     * @return 结果
     */
    @Override
    public int deleteTFailureById(Long id)
    {
        return tFailureMapper.deleteTFailureById(id);
    }
}
