package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TUrgentContacts;

/**
 * 应急联系人Service接口
 * 
 * @author zehong
 * @date 2023-12-19
 */
public interface ITUrgentContactsService 
{
    /**
     * 查询应急联系人
     * 
     * @param id 应急联系人ID
     * @return 应急联系人
     */
    public TUrgentContacts selectTUrgentContactsById(Long id);

    /**
     * 查询应急联系人列表
     * 
     * @param tUrgentContacts 应急联系人
     * @return 应急联系人集合
     */
    public List<TUrgentContacts> selectTUrgentContactsList(TUrgentContacts tUrgentContacts);

    /**
     * 新增应急联系人
     * 
     * @param tUrgentContacts 应急联系人
     * @return 结果
     */
    public int insertTUrgentContacts(TUrgentContacts tUrgentContacts);

    /**
     * 修改应急联系人
     * 
     * @param tUrgentContacts 应急联系人
     * @return 结果
     */
    public int updateTUrgentContacts(TUrgentContacts tUrgentContacts);

    /**
     * 批量删除应急联系人
     * 
     * @param ids 需要删除的应急联系人ID
     * @return 结果
     */
    public int deleteTUrgentContactsByIds(Long[] ids);

    /**
     * 删除应急联系人信息
     * 
     * @param id 应急联系人ID
     * @return 结果
     */
    public int deleteTUrgentContactsById(Long id);
}
