package com.zehong.system.service;

import com.zehong.system.domain.TPipeUser;

import java.util.List;

/**
 * 管线巡线人员分配Service接口
 * 
 * @author zehong
 * @date 2023-11-16
 */
public interface ITPipeUserService 
{
    /**
     * 查询管线巡线人员分配
     * 
     * @param id 管线巡线人员分配ID
     * @return 管线巡线人员分配
     */
    public TPipeUser selectTPipeUserById(Long id);

    /**
     * 查询管线巡线人员分配列表
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 管线巡线人员分配集合
     */
    public List<TPipeUser> selectTPipeUserList(TPipeUser tPipeUser);

    /**
     * 新增管线巡线人员分配
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 结果
     */
    public int insertTPipeUser(TPipeUser tPipeUser);

    /**
     * 修改管线巡线人员分配
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 结果
     */
    public int updateTPipeUser(TPipeUser tPipeUser);

    /**
     * 批量删除管线巡线人员分配
     * 
     * @param ids 需要删除的管线巡线人员分配ID
     * @return 结果
     */
    public int deleteTPipeUserByIds(Long[] ids);

    /**
     * 删除管线巡线人员分配信息
     * 
     * @param id 管线巡线人员分配ID
     * @return 结果
     */
    public int deleteTPipeUserById(Long id);


    /**
     * 根据用户和管道主键删除
     * @param userId 用户主键
     * @param pipeId 管道主键
     * @return
     */
    int deleteTPipeUserByUserIdAndPipeId(Long userId,Long pipeId);
}
