package com.zehong.system.service;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TPipeTask;
import com.zehong.system.domain.vo.TaskInspectStatisticsByPipVo;

/**
 * 管线巡线任务Service接口
 * 
 * @author zehong
 * @date 2023-11-17
 */
public interface ITPipeTaskService 
{
    /**
     * 查询管线巡线任务
     * 
     * @param id 管线巡线任务ID
     * @return 管线巡线任务
     */
    public TPipeTask selectTPipeTaskById(Long id);

    /**
     * 查询管线巡线任务列表
     * 
     * @param tPipeTask 管线巡线任务
     * @return 管线巡线任务集合
     */
    public List<TPipeTask> selectTPipeTaskList(TPipeTask tPipeTask);
    public List<TPipeTask> selectTwxPipeTaskList(TPipeTask tPipeTask);

    /**
     * 新增管线巡线任务
     * 
     * @param tPipeTask 管线巡线任务
     * @return 结果
     */
    public int insertTPipeTask(TPipeTask tPipeTask);

    /**
     * 修改管线巡线任务
     * 
     * @param tPipeTask 管线巡线任务
     * @return 结果
     */
    public int updateTPipeTask(TPipeTask tPipeTask);

    /**
     * 批量删除管线巡线任务
     * 
     * @param ids 需要删除的管线巡线任务ID
     * @return 结果
     */
    public int deleteTPipeTaskByIds(Long[] ids);

    /**
     * 删除管线巡线任务信息
     * 
     * @param id 管线巡线任务ID
     * @return 结果
     */
    public int deleteTPipeTaskById(Long id);

    /**
     * 巡线人巡线点统计
     * @param param
     * @return
     */
    List<Map<String,Object>> selectTaskInspectStatisticsByUser(Map<String,Object> param);

    /**
     * 管道巡检点统计
     * @param param 入参
     * @return
     */
    List<Map<String,Object>> selectTaskInspectStatisticsByPipe(TaskInspectStatisticsByPipVo param);
}
