package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TGasData;

/**
 * 监测设备数据Service接口
 * 
 * @author zehong
 * @date 2024-03-02
 */
public interface ITGasDataService 
{
    /**
     * 查询监测设备数据
     * 
     * @param id 监测设备数据ID
     * @return 监测设备数据
     */
    public TGasData selectTGasDataById(Long id);

    /**
     * 查询监测设备数据列表
     * 
     * @param tGasData 监测设备数据
     * @return 监测设备数据集合
     */
    public List<TGasData> selectTGasDataList(TGasData tGasData);

    /**
     * 新增监测设备数据
     * 
     * @param tGasData 监测设备数据
     * @return 结果
     */
    public int insertTGasData(TGasData tGasData);

    /**
     * 修改监测设备数据
     * 
     * @param tGasData 监测设备数据
     * @return 结果
     */
    public int updateTGasData(TGasData tGasData);

    /**
     * 批量删除监测设备数据
     * 
     * @param ids 需要删除的监测设备数据ID
     * @return 结果
     */
    public int deleteTGasDataByIds(Long[] ids);

    /**
     * 删除监测设备数据信息
     * 
     * @param id 监测设备数据ID
     * @return 结果
     */
    public int deleteTGasDataById(Long id);
}
