package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyAlarmNotifyRecord;

/**
 * 应急报警通知记录Service接口
 * 
 * @author zehong
 * @date 2024-12-10
 */
public interface ITEmergencyAlarmNotifyRecordService 
{
    /**
     * 查询应急报警通知记录
     * 
     * @param id 应急报警通知记录ID
     * @return 应急报警通知记录
     */
    public TEmergencyAlarmNotifyRecord selectTEmergencyAlarmNotifyRecordById(Long id);

    /**
     * 查询应急报警通知记录列表
     * 
     * @param tEmergencyAlarmNotifyRecord 应急报警通知记录
     * @return 应急报警通知记录集合
     */
    public List<TEmergencyAlarmNotifyRecord> selectTEmergencyAlarmNotifyRecordList(TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord);

    /**
     * 新增应急报警通知记录
     * 
     * @param tEmergencyAlarmNotifyRecord 应急报警通知记录
     * @return 结果
     */
    public int insertTEmergencyAlarmNotifyRecord(TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord);

    /**
     * 修改应急报警通知记录
     * 
     * @param tEmergencyAlarmNotifyRecord 应急报警通知记录
     * @return 结果
     */
    public int updateTEmergencyAlarmNotifyRecord(TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord);

    /**
     * 批量删除应急报警通知记录
     * 
     * @param ids 需要删除的应急报警通知记录ID
     * @return 结果
     */
    public int deleteTEmergencyAlarmNotifyRecordByIds(Long[] ids);

    /**
     * 删除应急报警通知记录信息
     * 
     * @param id 应急报警通知记录ID
     * @return 结果
     */
    public int deleteTEmergencyAlarmNotifyRecordById(Long id);

    /**
     * 通知
     * @param alarmId 报警主键
     */
    void alarmNotify(Long alarmId);
}
