package com.zehong.system.service;

import java.util.List;

import com.zehong.system.domain.TDeviceInfo;
import com.zehong.system.domain.TDeviceTask;
import com.zehong.system.domain.TDeviceTaskInspect;

/**
 * 设备巡检执行Service接口
 * 
 * @author zehong
 * @date 2023-12-11
 */
public interface ITDeviceTaskInspectService 
{
    /**
     * 查询设备巡检执行
     * 
     * @param id 设备巡检执行ID
     * @return 设备巡检执行
     */
    public TDeviceTaskInspect selectTDeviceTaskInspectById(Long id);

    /**
     * 查询设备巡检执行列表
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 设备巡检执行集合
     */
    public List<TDeviceTaskInspect> selectTDeviceTaskInspectList(TDeviceTaskInspect tDeviceTaskInspect);

    /**
     * 设备检测情况列表
     * @param
     * @return
     */
    public List<TDeviceInfo> deviceInspectList(TDeviceInfo tDeviceInfo);


    /**
     * 新增设备巡检执行
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 结果
     */
    public int insertTDeviceTaskInspect(TDeviceTaskInspect tDeviceTaskInspect);

    /**
     * 修改设备巡检执行
     * 
     * @param tDeviceTaskInspect 设备巡检执行
     * @return 结果
     */
    public int updateTDeviceTaskInspect(TDeviceTaskInspect tDeviceTaskInspect);

    /**
     * 批量删除设备巡检执行
     * 
     * @param ids 需要删除的设备巡检执行ID
     * @return 结果
     */
    public int deleteTDeviceTaskInspectByIds(Long[] ids);

    /**
     * 删除设备巡检执行信息
     * 
     * @param id 设备巡检执行ID
     * @return 结果
     */
    public int deleteTDeviceTaskInspectById(Long id);

    /**
     * 设备巡检信息
     * @param tDeviceTaskInspect 巡检实体
     * @return
     */
    List<TDeviceTaskInspect> selectTDeviceTaskInspectInfoList(TDeviceTaskInspect tDeviceTaskInspect);
}
