package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TBusiness;

/**
 * 工商业用户Service接口
 * 
 * @author zehong
 * @date 2023-11-03
 */
public interface ITBusinessService 
{
    /**
     * 查询工商业用户
     * 
     * @param id 工商业用户ID
     * @return 工商业用户
     */
    public TBusiness selectTBusinessById(Long id);

    /**
     * 查询工商业用户列表
     * 
     * @param tBusiness 工商业用户
     * @return 工商业用户集合
     */
    public List<TBusiness> selectTBusinessList(TBusiness tBusiness);

    /**
     * 新增工商业用户
     * 
     * @param tBusiness 工商业用户
     * @return 结果
     */
    public int insertTBusiness(TBusiness tBusiness);

    /**
     * 修改工商业用户
     * 
     * @param tBusiness 工商业用户
     * @return 结果
     */
    public int updateTBusiness(TBusiness tBusiness);

    /**
     * 批量删除工商业用户
     * 
     * @param ids 需要删除的工商业用户ID
     * @return 结果
     */
    public int deleteTBusinessByIds(Long[] ids);

    /**
     * 删除工商业用户信息
     * 
     * @param id 工商业用户ID
     * @return 结果
     */
    public int deleteTBusinessById(Long id);
}
