package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TThirdBuildInspect;

/**
 * 第三方施工执行Mapper接口
 * 
 * @author zehong
 * @date 2023-12-22
 */
public interface TThirdBuildInspectMapper 
{
    /**
     * 查询第三方施工执行
     * 
     * @param id 第三方施工执行ID
     * @return 第三方施工执行
     */
    public TThirdBuildInspect selectTThirdBuildInspectById(Long id);

    /**
     * 查询第三方施工执行列表
     * 
     * @param tThirdBuildInspect 第三方施工执行
     * @return 第三方施工执行集合
     */
    public List<TThirdBuildInspect> selectTThirdBuildInspectList(TThirdBuildInspect tThirdBuildInspect);

    /**
     * 新增第三方施工执行
     * 
     * @param tThirdBuildInspect 第三方施工执行
     * @return 结果
     */
    public int insertTThirdBuildInspect(TThirdBuildInspect tThirdBuildInspect);

    /**
     * 修改第三方施工执行
     * 
     * @param tThirdBuildInspect 第三方施工执行
     * @return 结果
     */
    public int updateTThirdBuildInspect(TThirdBuildInspect tThirdBuildInspect);

    /**
     * 删除第三方施工执行
     * 
     * @param id 第三方施工执行ID
     * @return 结果
     */
    public int deleteTThirdBuildInspectById(Long id);

    /**
     * 批量删除第三方施工执行
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTThirdBuildInspectByIds(Long[] ids);
}
