package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TTaskInspect;
import com.zehong.system.domain.vo.UserTaskInspect;
import com.zehong.system.domain.vo.Userinstpect;

/**
 * 安检任务执行Mapper接口
 * 
 * @author zehong
 * @date 2023-11-07
 */
public interface TTaskInspectMapper 
{
    /**
     * 查询安检任务执行
     * 
     * @param id 安检任务执行ID
     * @return 安检任务执行
     */
    public TTaskInspect selectTTaskInspectById(Long id);

    /**
     * 查询安检任务执行列表
     * 
     * @param tTaskInspect 安检任务执行
     * @return 安检任务执行集合
     */
    public List<TTaskInspect> selectTTaskInspectList(TTaskInspect tTaskInspect);
    public List<TTaskInspect> selectJuminInspectList(TTaskInspect tTaskInspect);


    /**
     * 居民用户安检任务执行
     * @return
     */
    public List<UserTaskInspect> selectJMinspect(UserTaskInspect ut);
    public List<UserTaskInspect> selectCYinspect(UserTaskInspect ut);

    /**
     * 未完成安检单
     * @param inspect
     * @return
     */
    public TTaskInspect selectBytaskIduserId(TTaskInspect inspect);
    /**
     * 新增安检任务执行
     * 
     * @param tTaskInspect 安检任务执行
     * @return 结果
     */
    public int insertTTaskInspect(TTaskInspect tTaskInspect);

    /**
     * 修改安检任务执行
     * 
     * @param tTaskInspect 安检任务执行
     * @return 结果
     */
    public int updateTTaskInspect(TTaskInspect tTaskInspect);

    /**
     * 删除安检任务执行
     * 
     * @param id 安检任务执行ID
     * @return 结果
     */
    public int deleteTTaskInspectById(Long id);

    /**
     * 批量删除安检任务执行
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTaskInspectByIds(Long[] ids);

    /**
     * 安检任务统计
     * @param tTaskInspect 安检实体
     * @return
     */
    List<Map<String,Object>> taskInspectStatistics(TTaskInspect tTaskInspect);

    /**
     * 小程序居民安检列表 详情
     * @param tTaskInspect
     * @return
     */
    List<Userinstpect> jmAnjianDetail(Userinstpect userinstpect);
    List<Userinstpect> cyAnjianDetail(Userinstpect userinstpect);
    List<Userinstpect> gyAnjianDetail(Userinstpect userinstpect);

    /**
     * 到访不遇查询
     * @param userTaskInspect
     * @return
     */
    List<UserTaskInspect> selectVisitorMissInfo (UserTaskInspect userTaskInspect);

    /**
     * 居民安检项统计
     * @param params 入参
     * @return
     */
    List<TTaskInspect> selectResidentInspectItemStatistics(Map<String,Object> params);
}
