package com.zehong.system.mapper;

import java.util.List;
import java.util.Map;

import com.zehong.system.domain.TSiteStationInfo;

/**
 * 场站信息Mapper接口
 * 
 * @author zehong
 * @date 2023-11-02
 */
public interface TSiteStationInfoMapper 
{
    /**
     * 查询场站信息
     * 
     * @param siteStationId 场站信息ID
     * @return 场站信息
     */
    public TSiteStationInfo selectTSiteStationInfoById(Long siteStationId);

    /**
     *  场站安检模板
     * @return
     */
    public Map<String,Object> selectStationJsonById(Long stationId);

    /**
     * 查询场站信息列表
     * 
     * @param tSiteStationInfo 场站信息
     * @return 场站信息集合
     */
    public List<TSiteStationInfo> selectTSiteStationInfoList(TSiteStationInfo tSiteStationInfo);
    public List<TSiteStationInfo> stationInspectList(TSiteStationInfo tSiteStationInfo);

    /**
     * 新增场站信息
     * 
     * @param tSiteStationInfo 场站信息
     * @return 结果
     */
    public int insertTSiteStationInfo(TSiteStationInfo tSiteStationInfo);

    /**
     * 修改场站信息
     * 
     * @param tSiteStationInfo 场站信息
     * @return 结果
     */
    public int updateTSiteStationInfo(TSiteStationInfo tSiteStationInfo);

    /**
     * 删除场站信息
     * 
     * @param siteStationId 场站信息ID
     * @return 结果
     */
    public int deleteTSiteStationInfoById(Long siteStationId);

    /**
     * 批量删除场站信息
     * 
     * @param siteStationIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSiteStationInfoByIds(Long[] siteStationIds);
}
