package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TPipeUser;
import org.apache.ibatis.annotations.Param;

/**
 * 管线巡线人员分配Mapper接口
 * 
 * @author zehong
 * @date 2023-11-16
 */
public interface TPipeUserMapper 
{
    /**
     * 查询管线巡线人员分配
     * 
     * @param id 管线巡线人员分配ID
     * @return 管线巡线人员分配
     */
    public TPipeUser selectTPipeUserById(Long id);

    /**
     * 查询管线巡线人员分配列表
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 管线巡线人员分配集合
     */
    public List<TPipeUser> selectTPipeUserList(TPipeUser tPipeUser);

    /**
     * 新增管线巡线人员分配
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 结果
     */
    public int insertTPipeUser(TPipeUser tPipeUser);

    /**
     * 修改管线巡线人员分配
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 结果
     */
    public int updateTPipeUser(TPipeUser tPipeUser);

    /**
     * 删除管线巡线人员分配
     * 
     * @param id 管线巡线人员分配ID
     * @return 结果
     */
    public int deleteTPipeUserById(Long id);

    /**
     * 批量删除管线巡线人员分配
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipeUserByIds(Long[] ids);

    /**
     * 根据用户和管道主键删除
     * @param userId 用户主键
     * @param pipeId 管道主键
     * @return
     */
    int deleteTPipeUserByUserIdAndPipeId(@Param("userId")Long userId, @Param("pipeId")Long pipeId);

    /**
     * 获取巡检人管道信息
     * @param tPipeUser
     * @return
     */
    List<TPipeUser> selectUserPipeInfo(TPipeUser tPipeUser);
}
