package com.zehong.system.mapper;

import java.util.Date;
import java.util.List;

import com.zehong.system.domain.TPipePoint;
import com.zehong.system.domain.TPipeTaskInspect;
import org.apache.ibatis.annotations.Param;

/**
 * 管线巡线任务执行Mapper接口
 * 
 * @author zehong
 * @date 2023-11-17
 */
public interface TPipeTaskInspectMapper 
{
    /**
     * 查询管线巡线任务执行
     * 
     * @param id 管线巡线任务执行ID
     * @return 管线巡线任务执行
     */
    public TPipeTaskInspect selectTPipeTaskInspectById(Long id);

    /**
     * 查询管线巡线任务执行列表
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行集合
     */
    public List<TPipeTaskInspect> selectTPipeTaskInspectList(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 根据距离排序打卡点
     * @param tPipeTaskInspect
     * @return
     */
    public List<TPipeTaskInspect> selectPipeDistance(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 新增管线巡线任务执行
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 结果
     */
    public int insertTPipeTaskInspect(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 修改管线巡线任务执行
     * 
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 结果
     */
    public int updateTPipeTaskInspect(TPipeTaskInspect tPipeTaskInspect);

    /**
     * 删除管线巡线任务执行
     * 
     * @param id 管线巡线任务执行ID
     * @return 结果
     */
    public int deleteTPipeTaskInspectById(Long id);

    /**
     * 批量删除管线巡线任务执行
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTPipeTaskInspectByIds(Long[] ids);

    public int inserts(@Param("list")List<TPipePoint> list, @Param("taskId") Long taskId,@Param("createTime")Date createTime);

    /**
     * 查询管线巡线任务打卡点执行列表
     *
     * @param tPipeTaskInspect 管线巡线任务执行
     * @return 管线巡线任务执行集合
     */
    List<TPipeTaskInspect> selectTPipeTaskPointInspectList(TPipeTaskInspect tPipeTaskInspect);
}
